/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cors;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;

public class CorsFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CorsFilter.class);
    private final RequestMatcher corsRequestMatcher;
    private final AntPathMatcher antPathMatcher;
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private boolean allowedCredentials;
    private List<String> exposedHeaders;
    private int maxAge;

    public CorsFilter(List<String> corsMapping) {
        this.corsRequestMatcher = new OrRequestMatcher(corsMapping.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList()));
        this.antPathMatcher = new AntPathMatcher();
        this.antPathMatcher.setTrimTokens(false);
        this.antPathMatcher.setCaseSensitive(false);
    }

    public CorsFilter(List<String> corsMapping, List<String> allowedOrigins, List<String> allowedMethods, List<String> allowedHeaders, List<String> exposedHeaders, boolean allowedCredentials, int maxAge) {
        this(corsMapping);
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.allowedCredentials = allowedCredentials;
        this.exposedHeaders = exposedHeaders;
        this.maxAge = maxAge;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String origin = request.getHeader("Origin");
        if (StringUtils.isBlank((CharSequence)origin) || !this.getCorsRequestMatcher().matches(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.isAllowedOrigin(origin)) {
            response.setHeader("Access-Control-Allow-Origin", origin);
        }
        if (null != this.getAllowedMethods()) {
            response.setHeader("Access-Control-Allow-Methods", String.join((CharSequence)",", this.getAllowedMethods()));
        }
        if (0 < this.getMaxAge()) {
            response.setHeader("Access-Control-Max-Age", String.valueOf(this.getMaxAge()));
        }
        if (null != this.getAllowedHeaders()) {
            response.setHeader("Access-Control-Allow-Headers", String.join((CharSequence)",", this.getAllowedHeaders()));
        }
        if (this.isAllowedCredentials()) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        if (null != this.getExposedHeaders()) {
            response.addHeader("Access-Control-Expose-Headers", String.join((CharSequence)",", this.getExposedHeaders()));
        }
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setStatus(200);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isAllowedOrigin(String origin) {
        return this.getAllowedOrigins().stream().anyMatch(allowedOrigin -> this.getAntPathMatcher().match(allowedOrigin, origin));
    }

    public RequestMatcher getCorsRequestMatcher() {
        return this.corsRequestMatcher;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public boolean isAllowedCredentials() {
        return this.allowedCredentials;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public int getMaxAge() {
        return this.maxAge;
    }
}

