/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

public interface WebTestHelper {
    public MockMvc getMockMvc();

    public ObjectMapper getObjectMapper();

    default public void preExecute(MockHttpServletRequestBuilder request) {
    }

    default public <T> T execute(MockHttpServletRequestBuilder request, HttpStatus expectedStatus, Class<T> returnType) throws Exception {
        return this.execute(request, expectedStatus, this.getObjectMapper().getTypeFactory().constructType(returnType));
    }

    default public <T> T execute(MockHttpServletRequestBuilder request, HttpStatus expectedStatus, JavaType returnType) throws Exception {
        request.accept(new MediaType[]{MediaType.APPLICATION_JSON});
        MvcResult result = this.execute(request, expectedStatus);
        if (StringUtils.isBlank((CharSequence)result.getResponse().getContentAsString())) {
            return null;
        }
        return (T)this.getObjectMapper().readValue(result.getResponse().getContentAsString(), returnType);
    }

    default public MvcResult execute(MockHttpServletRequestBuilder request, HttpStatus expectedStatus) throws Exception {
        MvcResult result = this.execute(request);
        Assertions.assertThat((int)result.getResponse().getStatus()).isEqualTo(expectedStatus.value());
        return result;
    }

    default public MvcResult execute(MockHttpServletRequestBuilder request) throws Exception {
        this.preExecute(request);
        MvcResult result = this.getMockMvc().perform((RequestBuilder)request).andReturn();
        LoggerFactory.getLogger(this.getClass()).info("call details:\nurl: {} {}\nstatus: {}\nrequest:\n{}\nresponse:\n{}\n", new Object[]{result.getRequest().getMethod(), result.getRequest().getRequestURI(), result.getResponse().getStatus(), result.getRequest().getContentAsString(), result.getResponse().getContentAsString()});
        return result;
    }
}

