/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public interface BaseExceptionControllerAdvice {
    public static final Logger log = LoggerFactory.getLogger(BaseExceptionControllerAdvice.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    default public void handle(Exception ex) {
        log.error("unhandled exception occur", (Throwable)ex);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    default public void handle(UnsupportedOperationException ex) {
        log.error("not allowed service called", (Throwable)ex);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    @ResponseBody
    default public List<String> handle(MethodArgumentNotValidException ex, Locale locale) {
        log.debug("method argument not valid, [{}]", (Object)ex.getMessage());
        return ex.getBindingResult().getAllErrors().stream().map(error -> this.getMessageSource().getMessage(Objects.requireNonNull(error.getCode()), error.getArguments(), locale)).collect(Collectors.toList());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    default public ResponseEntity<?> handle(HttpRequestMethodNotSupportedException ex) {
        log.trace("http method not supported.", (Throwable)ex);
        return new ResponseEntity((Object)"%s not supported, supported methods are: %s".formatted(ex.getMethod(), ex.getSupportedHttpMethods()), (HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, HttpMessageNotReadableException.class, MethodArgumentTypeMismatchException.class, MissingServletRequestParameterException.class, BindException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    @ResponseBody
    default public List<String> handleInvalidDataError(Exception ex) {
        log.error("exception occurred reading request data ", (Throwable)ex);
        return List.of(ex.getMessage());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    default public void handle(AuthenticationException ex) {
        log.error("Authentication Error: ", (Throwable)ex);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    default public void handle(AccessDeniedException ex) {
        log.warn("AccessDenied: ", (Throwable)ex);
    }

    public MessageSource getMessageSource();
}

