/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import lombok.Generated;
import org.bardframework.commons.web.BaseExceptionControllerAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;

public class ExceptionHandlerFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerFilter.class);
    private final ObjectMapper objectMapper;
    private final Object exceptionControllerAdvice;
    private final ExceptionHandlerMethodResolver exceptionHandlerMethodResolver;

    public <T extends BaseExceptionControllerAdvice> ExceptionHandlerFilter(T exceptionControllerAdvice, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.exceptionControllerAdvice = exceptionControllerAdvice;
        this.exceptionHandlerMethodResolver = new ExceptionHandlerMethodResolver(exceptionControllerAdvice.getClass());
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException {
        try {
            chain.doFilter(req, res);
        }
        catch (Throwable ex) {
            if (ex instanceof ServletException && null != ex.getCause()) {
                this.handle((HttpServletResponse)res, ex.getCause());
            }
            this.handle((HttpServletResponse)res, ex);
        }
    }

    public void handle(HttpServletResponse response, Throwable ex) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        Method method = this.exceptionHandlerMethodResolver.resolveMethodByExceptionType(ex.getClass());
        if (null == method) {
            log.error("{} exception occurred, but can't handle it using advices", ex.getClass(), (Object)ex);
            return;
        }
        try {
            Object resolverResponse = method.invoke(this.exceptionControllerAdvice, ex);
            this.objectMapper.writeValue((Writer)response.getWriter(), resolverResponse);
            response.setContentType("application/json");
        }
        catch (Exception e) {
            log.error("error calling exception\n \nhandler method [{}] and setting result to response", (Object)method.getName(), (Object)e);
        }
    }
}

