/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.crud;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.bardframework.base.crud.BaseCriteriaAbstract;
import org.bardframework.base.crud.BaseModelAbstract;
import org.bardframework.base.crud.BaseRepository;
import org.bardframework.base.crud.BaseService;
import org.bardframework.base.filter.IdFilter;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseServiceAbstract<M extends BaseModelAbstract<I>, C extends BaseCriteriaAbstract<I>, D, R extends BaseRepository<M, C, I, U>, I extends Comparable<? super I>, U>
implements BaseService<M, C, D, I, U> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final Class<M> modelClazz;
    protected final Class<C> criteriaClazz;
    @Autowired
    protected R repository;

    public BaseServiceAbstract() {
        ParameterizedType parameterizedType = null;
        for (Class<?> targetClazz = this.getClass(); (null == parameterizedType || parameterizedType.getActualTypeArguments().length < 2) && null != targetClazz; targetClazz = targetClazz.getSuperclass()) {
            parameterizedType = targetClazz.getGenericSuperclass() instanceof ParameterizedType ? (ParameterizedType)targetClazz.getGenericSuperclass() : null;
        }
        try {
            this.modelClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.criteriaClazz = (Class)parameterizedType.getActualTypeArguments()[1];
        }
        catch (Exception e) {
            this.LOGGER.debug("can't determine class from generic type!", (Throwable)e);
            throw new IllegalArgumentException("can't determine class from generic type!", e);
        }
    }

    public M getEmptyModel() {
        try {
            return (M)((BaseModelAbstract)this.modelClazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOGGER.error("can't instantiate model class using empty constructor {}", this.modelClazz, (Object)e);
            throw new IllegalArgumentException("can't instantiate model class using empty constructor" + this.modelClazz, e);
        }
    }

    public C getEmptyCriteria() {
        BaseCriteriaAbstract criteria;
        try {
            criteria = (BaseCriteriaAbstract)this.criteriaClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOGGER.error("can't instantiate criteria class using empty constructor {}", this.criteriaClazz, (Object)e);
            throw new IllegalArgumentException("can't instantiate criteria class using empty constructor" + this.criteriaClazz, e);
        }
        return (C)criteria;
    }

    @Override
    public List<M> get(List<I> ids, U user) {
        return this.getRepository().get(ids, user);
    }

    @Override
    public List<M> get(C criteria, U user) {
        return this.getRepository().get(criteria, user);
    }

    public M getOne(C criteria, U user) {
        return this.getRepository().getOne(criteria, user);
    }

    @Override
    @Transactional
    public long delete(C criteria, U user) {
        List models = this.getRepository().get(criteria, user);
        if (CollectionUtils.isEmpty(models)) {
            return 0L;
        }
        for (BaseModelAbstract model : models) {
            this.preDelete(model, user);
        }
        long deletedCount = this.getRepository().directDelete(models.stream().map(BaseModelAbstract::getId).collect(Collectors.toList()), user);
        if (deletedCount > 0L) {
            for (BaseModelAbstract model : models) {
                this.postDelete(model, user);
            }
        }
        if ((long)models.size() != deletedCount) {
            this.LOGGER.warn("deleting with criteria, expect delete {} item(s), but {} deleted.", (Object)models.size(), (Object)deletedCount);
        }
        return deletedCount;
    }

    @Override
    @Transactional
    public long delete(List<I> ids, U user) {
        C criteria = this.getEmptyCriteria();
        ((BaseCriteriaAbstract)criteria).setId((IdFilter)new IdFilter().setIn(ids));
        return this.delete((I)criteria, user);
    }

    @Override
    @Transactional
    public long delete(I id, U user) {
        C criteria = this.getEmptyCriteria();
        ((BaseCriteriaAbstract)criteria).setId((IdFilter)new IdFilter().setEquals(id));
        return this.delete((I)criteria, user);
    }

    protected void preDelete(M model, U user) {
    }

    protected void postDelete(M deletedModel, U user) {
    }

    @Override
    @Transactional
    public M save(D dto, U user) {
        AssertionUtils.notNull(dto, (String)"dto cannot be null.");
        this.preSave(dto, user);
        M model = this.getRepository().save(this.onSave(dto, user), user);
        this.postSave(model, dto, user);
        return this.getRepository().get(((BaseModelAbstract)model).getId(), user);
    }

    @Override
    @Transactional
    public List<M> save(List<D> dtos, U user) {
        AssertionUtils.notEmpty(dtos, (String)"dtos cannot be null or empty.");
        List list = new ArrayList();
        for (D dto : dtos) {
            this.preSave(dto, user);
            list.add(this.onSave(dto, user));
        }
        list = this.getRepository().save(list, user);
        if (list.size() != dtos.size()) {
            throw new IllegalStateException("invalid save operation, save " + dtos.size() + " dtos, but result size is " + list.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.postSave((BaseModelAbstract)list.get(i), dtos.get(i), user);
        }
        return list;
    }

    protected abstract M onSave(D var1, U var2);

    protected void preSave(D dto, U user) {
    }

    protected void postSave(M savedModel, D dto, U user) {
    }

    @Override
    @Transactional
    public M update(I id, D dto, U user) {
        Object model = this.getRepository().get(id, user);
        this.preUpdate(model, dto, user);
        this.getRepository().update(this.onUpdate(dto, model, user), user);
        this.postUpdate(model, dto, user);
        return this.getRepository().get(((BaseModelAbstract)model).getId(), user);
    }

    protected abstract M onUpdate(D var1, M var2, U var3);

    protected void preUpdate(M previousModel, D dto, U user) {
    }

    protected void postUpdate(M updatedModel, D dto, U user) {
    }

    public List<I> getIds(C criteria, U user) {
        return this.getRepository().getIds(criteria, user);
    }

    public long getCount(C criteria, U user) {
        return this.getRepository().getCount(criteria, user);
    }

    public boolean isExist(C criteria, U user) {
        return this.getRepository().isExist(criteria, user);
    }

    public boolean isNotExist(C criteria, U user) {
        return this.getRepository().isNotExist(criteria, user);
    }

    public R getRepository() {
        return this.repository;
    }

    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public final Page<M> get(C criteria, Pageable pageable, U user) {
        Page list = this.getRepository().get(criteria, pageable, user);
        return this.postFetch(list, pageable, user);
    }

    protected Page<M> postFetch(Page<M> page, Pageable pageable, U user) {
        return page;
    }

    protected M postFetch(M model, U user) {
        return model;
    }

    @Override
    public final M get(I id, U user) {
        Object model = this.getRepository().get(id, user);
        if (model == null) {
            return null;
        }
        return this.postFetch(model, user);
    }

    protected Page<M> paging(List<M> list, Pageable pageable, LongSupplier supplier) {
        return pageable.isUnpaged() ? new PageImpl(list) : PageableExecutionUtils.getPage(list, (Pageable)pageable, (LongSupplier)supplier);
    }

    public List<M> getAll(U user) {
        return this.getRepository().get(this.getEmptyCriteria(), user);
    }
}

