/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.datatable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.bardframework.base.datatable.FilteringType;
import org.bardframework.base.datatable.QueryType;
import org.bardframework.base.datatable.ResultType;
import org.bardframework.base.datatable.Sort;
import org.bardframework.commons.jackson.converter.StringToBooleanConverter;
import org.bardframework.commons.jackson.converter.StringToByteConverter;
import org.bardframework.commons.jackson.converter.StringToIntegerConverter;
import org.bardframework.commons.jackson.converter.StringToLongConverter;
import org.bardframework.commons.jackson.converter.StringToShortConverter;
import org.bardframework.crud.commons.converter.StringToEnumConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public abstract class HeaderAbstract {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HeaderAbstract.class);
    protected String path;
    protected QueryType queryType = QueryType.NONE;
    protected FilteringType filterType = FilteringType.NONE;
    protected ResultType resultType = ResultType.PRIMITIVE;
    protected boolean visible = true;
    protected boolean searchable = false;
    protected boolean sortable = false;
    protected Sort sort;
    protected String mask;
    protected Converter<?, ?> inputConverter;
    protected Converter<?, ?> outputConverter;
    protected List<String> messageKeys;

    public void validate(Class<?> mainClazz) {
        if (this.filterType != FilteringType.NONE && (this.filterType == FilteringType.MULTI_SELECT || this.filterType == FilteringType.SINGLE_SELECT || this.filterType == FilteringType.TREE_SELECT || this.filterType == FilteringType.MIN_MAX)) {
            if (this.searchable) {
                LOGGER.error("invalid HeaderAbstract definition on '{}'@'{}' class,searchable can'reflection apply for (SINGLE|MULTI|TREE)_SELECT, MIN_MAX", (Object)this.path, (Object)mainClazz.getSimpleName());
                throw new IllegalArgumentException("searchable can'reflection apply for (SINGLE|MULTI|TREE)_SELECT");
            }
            if (this.sortable) {
                LOGGER.error("invalid HeaderAbstract definition on '{}'@'{}' class,sortable can'reflection apply for (SINGLE|MULTI|TREE)_SELECT, MIN_MAX", (Object)this.path, (Object)mainClazz.getSimpleName());
                throw new IllegalArgumentException("sortable can'reflection apply for (SINGLE|MULTI|TREE)_SELECT");
            }
        }
    }

    public void determineConverters(Class<?> valueType) {
        Class<StringToEnumConverter> inputConverterClazz = null;
        Class outputConverterClazz = null;
        if (Enum.class.isAssignableFrom(valueType)) {
            inputConverterClazz = StringToEnumConverter.class;
        } else if (!LocalDate.class.isAssignableFrom(valueType) && !LocalDateTime.class.isAssignableFrom(valueType)) {
            if (Boolean.class.isAssignableFrom(valueType) || Boolean.TYPE.isAssignableFrom(valueType)) {
                inputConverterClazz = StringToBooleanConverter.class;
            } else if (Long.class.isAssignableFrom(valueType) || Long.TYPE.isAssignableFrom(valueType)) {
                inputConverterClazz = StringToLongConverter.class;
                outputConverterClazz = null;
            } else if (Integer.class.isAssignableFrom(valueType) || Integer.TYPE.isAssignableFrom(valueType)) {
                inputConverterClazz = StringToIntegerConverter.class;
                outputConverterClazz = null;
            } else if (Short.class.isAssignableFrom(valueType) || Short.TYPE.isAssignableFrom(valueType)) {
                inputConverterClazz = StringToShortConverter.class;
                outputConverterClazz = null;
            } else if (Byte.class.isAssignableFrom(valueType) || Byte.TYPE.isAssignableFrom(valueType)) {
                inputConverterClazz = StringToByteConverter.class;
                outputConverterClazz = null;
            }
        }
        if (null != inputConverterClazz) {
            try {
                this.inputConverter = inputConverterClazz.equals(StringToEnumConverter.class) ? new StringToEnumConverter(valueType) : (Converter)inputConverterClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("can't instantiate input converter using empty constructor {}", inputConverterClazz, (Object)e);
                throw new IllegalArgumentException("can't instantiate input converter using empty constructor" + inputConverterClazz, e);
            }
        }
        if (null != outputConverterClazz) {
            try {
                this.outputConverter = (Converter)outputConverterClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("can't instantiate output converter using empty constructor {}", (Object)outputConverterClazz, (Object)e);
                throw new IllegalArgumentException("can't instantiate output converter using empty constructor" + outputConverterClazz, e);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public FilteringType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilteringType filterType) {
        this.filterType = filterType;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public Converter<?, ?> getInputConverter() {
        return this.inputConverter;
    }

    public void setInputConverter(Converter<?, ?> inputConverter) {
        this.inputConverter = inputConverter;
    }

    public Converter<?, ?> getOutputConverter() {
        return this.outputConverter;
    }

    public void setOutputConverter(Converter<?, ?> outputConverter) {
        this.outputConverter = outputConverter;
    }

    public List<String> getMessageKeys() {
        return this.messageKeys;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public String getMask() {
        return this.mask;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public String toString() {
        return "HeaderAbstract{path='" + this.getPath() + '\'' + '}';
    }
}

