/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.datatable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bardframework.base.UtilityMethods;
import org.bardframework.base.datatable.FilteringType;
import org.bardframework.base.datatable.HeaderAbstract;
import org.bardframework.base.datatable.ResultType;
import org.bardframework.base.datatable.Sort;
import org.bardframework.commons.utils.CollectionUtils;
import org.bardframework.commons.utils.StringUtils;
import org.bardframework.crud.commons.model.BaseData;
import org.springframework.context.MessageSource;

public class HeaderDto {
    private String id;
    private String name;
    private FilteringType filteringType;
    private ResultType resultType;
    private String mask;
    private boolean sortable;
    private Boolean visible;
    private boolean searchable;
    private List<BaseData> values;
    @JsonIgnore
    private List<String> messageKeys;
    private String query;
    private List<String> selected;
    private String min;
    private String max;
    private Sort sort;
    private int sortSequence;

    public HeaderDto() {
    }

    public HeaderDto(HeaderAbstract header, List<BaseData> values) {
        this(header);
        this.values = values;
    }

    public HeaderDto(HeaderAbstract header) {
        this.id = header.getPath();
        this.filteringType = header.getFilterType();
        this.resultType = header.getResultType();
        this.mask = header.getMask();
        this.sortable = header.isSortable();
        this.visible = header.isVisible();
        this.searchable = header.isSearchable();
        this.sort = header.getSort();
        this.messageKeys = header.getMessageKeys();
    }

    public void resolveName(MessageSource messageSource, Locale locale) {
        this.name = UtilityMethods.translate(this.messageKeys, messageSource, locale);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public FilteringType getFilteringType() {
        return this.filteringType;
    }

    public void setFilteringType(FilteringType filteringType) {
        this.filteringType = filteringType;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public List<BaseData> getValues() {
        try {
            return this.values.stream().sorted().collect(Collectors.toList());
        }
        catch (Exception e) {
            return this.values;
        }
    }

    public void setValues(List<BaseData> values) {
        this.values = values;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getSortSequence() {
        return this.sortSequence;
    }

    public void setSortSequence(int sortSequence) {
        this.sortSequence = sortSequence;
    }

    public List<String> getSelected() {
        return this.selected;
    }

    public void setSelected(List<String> selected) {
        this.selected = selected;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public String toString() {
        return "\nHeaderModel{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.resultType) + ", sort=" + (Object)((Object)this.sort) + ", mask='" + this.mask + '\'' + ", sortable=" + this.sortable + ", visible=" + this.visible + ", searchable=" + this.searchable + '}';
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.selected) && StringUtils.hasNotText((String)this.min) && StringUtils.hasNotText((String)this.max) && StringUtils.hasNotText((String)this.query) && this.visible != null && this.sort != null;
    }
}

