/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.form.model.filter.IdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseService<M extends BaseModel<I>, C extends BaseCriteria<I>, D, R extends BaseRepository<M, C, I, U>, I extends Serializable, U> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final Class<M> modelClazz;
    protected final Class<C> criteriaClazz;
    protected final Class<D> dtoClazz;
    protected final R repository;

    public BaseService(R repository) {
        this.repository = repository;
        this.modelClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)0);
        this.criteriaClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)1);
        this.dtoClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)2);
    }

    public C getEmptyCriteria() {
        return (C)((BaseCriteria)ReflectionUtils.newInstance(this.criteriaClazz));
    }

    public List<M> get(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be empty.");
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        C criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.get(criteria, user);
    }

    public M get(I id, U user) {
        AssertionUtils.notNull(id, (String)"Given id cannot be null.");
        C criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setEquals(id));
        List<M> models = this.get(criteria, user);
        if (CollectionUtils.isEmpty(models)) {
            return null;
        }
        return (M)((BaseModel)models.get(0));
    }

    public List<M> get(U user) {
        return this.get(this.getEmptyCriteria(), user);
    }

    public List<M> get(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        this.preFetch(criteria, user);
        List list = this.getRepository().get(criteria, user);
        this.postFetch(criteria, list, user);
        return list;
    }

    public M getOne(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        this.preFetch(criteria, user);
        Object model = this.getRepository().getOne(criteria, user);
        this.postFetch(criteria, Collections.singletonList(model), user);
        return model;
    }

    public PagedData<M> get(C criteria, Pageable pageable, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        AssertionUtils.notNull((Object)pageable, (String)"Given pageable cannot be null.");
        this.preFetch(criteria, user);
        PagedData pagedData = this.getRepository().get(criteria, pageable, user);
        this.postFetch(criteria, pagedData.getData(), user);
        return pagedData;
    }

    protected void preFetch(C criteria, U user) {
    }

    protected void postFetch(C criteria, List<M> result, U user) {
        for (BaseModel model : result) {
            this.postFetch(model, user);
        }
    }

    protected void postFetch(M model, U user) {
    }

    @Transactional
    public long delete(I id, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        return this.delete((C)List.of(id), user);
    }

    @Transactional
    public long delete(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be empty.");
        if (ids.isEmpty()) {
            return 0L;
        }
        C criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.delete(criteria, user);
    }

    @Transactional
    public long delete(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        List models = this.getRepository().get(criteria, user);
        if (CollectionUtils.isEmpty(models)) {
            return 0L;
        }
        this.preDelete(criteria, (M)models, user);
        C deleteCriteria = this.getEmptyCriteria();
        deleteCriteria.setIdFilter((IdFilter)new IdFilter().setIn((Collection)models.stream().map(BaseModel::getId).collect(Collectors.toList())));
        long deletedCount = this.getRepository().delete(deleteCriteria, user);
        this.postDelete(criteria, models, deletedCount, user);
        return deletedCount;
    }

    protected void preDelete(C criteria, List<M> models, U user) {
        for (BaseModel model : models) {
            this.preDelete(criteria, model, user);
        }
    }

    protected void preDelete(C criteria, M model, U user) {
    }

    protected void postDelete(C criteria, List<M> deletedModels, long deletedCount, U user) {
        if ((long)deletedModels.size() != deletedCount) {
            this.LOGGER.warn("deleting with criteria, expect delete {} item(s), but {} deleted.", (Object)deletedModels.size(), (Object)deletedCount);
        }
        for (BaseModel model : deletedModels) {
            this.postDelete(model, user);
        }
    }

    protected void postDelete(M deletedModel, U user) {
    }

    @Transactional
    public M save(D dto, U user) {
        AssertionUtils.notNull(dto, (String)"dto cannot be null.");
        return (M)((BaseModel)this.save(List.of(dto), user).get(0));
    }

    @Transactional
    public List<M> save(List<D> dtos, U user) {
        AssertionUtils.notNull(dtos, (String)"Given dtos cannot be null.");
        if (dtos.isEmpty()) {
            return Collections.emptyList();
        }
        this.preSave((D)dtos, user);
        List list = new ArrayList<M>();
        for (D dto : dtos) {
            list.add(this.onSave(dto, user));
        }
        list = this.getRepository().save(list, user);
        this.postSave((M)dtos, (D)list, user);
        return list.stream().map(model -> this.get((I)model.getId(), user)).collect(Collectors.toList());
    }

    protected abstract M onSave(D var1, U var2);

    protected void preSave(List<D> dtos, U user) {
        for (D dto : dtos) {
            this.preSave(dto, user);
        }
    }

    protected void preSave(D dto, U user) {
    }

    protected void postSave(List<D> dtos, List<M> savedModels, U user) {
        if (savedModels.size() != dtos.size()) {
            this.LOGGER.warn("saving dtos, expect save {} item(s), but {} saved.", (Object)dtos.size(), (Object)savedModels.size());
        }
        for (int i = 0; i < savedModels.size(); ++i) {
            this.postSave((BaseModel)savedModels.get(i), dtos.get(i), user);
        }
    }

    protected void postSave(M savedModel, D dto, U user) {
    }

    @Transactional
    public M patch(I id, Map<String, Object> patch, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        AssertionUtils.notEmpty(patch, (String)"patch cannot be empty.");
        Object model = this.getRepository().get(id, user);
        if (null == model) {
            return null;
        }
        BaseModel pre = (BaseModel)SerializationUtils.clone(model);
        this.prePatch(pre, patch, user);
        Object patched = this.getRepository().patch(id, patch, user);
        this.postPatch(pre, patched, patch, user);
        return this.get((I)model.getId(), user);
    }

    protected void prePatch(M previousModel, Map<String, Object> patch, U user) {
    }

    protected void postPatch(M previousModel, M patchedModel, Map<String, Object> patch, U user) {
    }

    @Transactional
    public M update(I id, D dto, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        AssertionUtils.notNull(dto, (String)"patch cannot be dto.");
        Object entity = this.getRepository().get(id, user);
        if (null == entity) {
            return null;
        }
        BaseModel pre = (BaseModel)SerializationUtils.clone(entity);
        this.preUpdate(pre, dto, user);
        this.onUpdate(dto, entity, user);
        Object updated = this.getRepository().update(entity, user);
        this.postUpdate(pre, updated, dto, user);
        return this.get((I)entity.getId(), user);
    }

    protected abstract void onUpdate(D var1, M var2, U var3);

    protected void preUpdate(M previousModel, D dto, U user) {
    }

    protected void postUpdate(M previousModel, M updatedModel, D dto, U user) {
    }

    public List<I> getIds(C criteria, U user) {
        return this.getRepository().getIds(criteria, user);
    }

    public long getCount(C criteria, U user) {
        return this.getRepository().getCount(criteria, user);
    }

    public boolean isExist(C criteria, U user) {
        return this.getRepository().isExist(criteria, user);
    }

    public boolean isNotExist(C criteria, U user) {
        return this.getRepository().isNotExist(criteria, user);
    }

    public R getRepository() {
        return this.repository;
    }
}

