/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.util.Map;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseService;
import org.bardframework.crud.api.base.ValidationGroups;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface WriteRestController<M extends BaseModel<I>, D, S extends BaseService<M, ?, D, ?, I, U>, I, U> {
    public static final String EMPTY_URL = "";
    public static final String ITEM_URL = "{id}";

    @PostMapping(value={""}, consumes={"application/json"})
    default public M SAVE(@RequestBody @Validated(value={ValidationGroups.Save.class}) D dto) {
        return ((BaseService)this.getService()).save(dto, this.getUser());
    }

    @PutMapping(value={"{id}"}, consumes={"application/json"})
    default public ResponseEntity<M> UPDATE(@PathVariable I id, @RequestBody @Validated(value={ValidationGroups.Update.class}) D dto) {
        Object result = ((BaseService)this.getService()).update(id, dto, this.getUser());
        if (null != result) {
            return ResponseEntity.ok().body(result);
        }
        return ResponseEntity.notFound().build();
    }

    @PatchMapping(value={"{id}"}, consumes={"application/json-patch+json"})
    default public ResponseEntity<M> PATCH(@PathVariable I id, @RequestBody Map<String, Object> patch) {
        Object result = ((BaseService)this.getService()).patch(id, patch, this.getUser());
        if (null != result) {
            return ResponseEntity.ok().body(result);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"{id}"})
    default public ResponseEntity<Long> DELETE(@PathVariable I id) {
        long result = ((BaseService)this.getService()).delete(id, this.getUser());
        if (result == 0L) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok().body((Object)result);
    }

    public S getService();

    public U getUser();
}

