/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.api.base.ReadService;
import org.bardframework.form.model.filter.IdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseService<M extends BaseModel<I>, C extends BaseCriteria<I>, D, R extends BaseRepository<M, C, I, U>, I, U>
extends ReadService<M, C, R, I, U> {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    protected final Class<D> dtoClazz = ReflectionUtils.getGenericArgType(this.getClass(), (int)2);

    public BaseService(R repository) {
        super(repository);
    }

    @Transactional
    public long delete(I id, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        return this.delete((C)List.of(id), user);
    }

    @Transactional
    public long delete(Collection<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"Given ids cannot be empty.");
        if (ids.isEmpty()) {
            return 0L;
        }
        Object criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(ids));
        return this.delete((C)criteria, user);
    }

    @Transactional
    public long delete(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null.");
        List models = ((BaseRepository)this.getRepository()).get(criteria, user);
        if (CollectionUtils.isEmpty(models)) {
            return 0L;
        }
        this.preDelete(criteria, (M)models, user);
        Object deleteCriteria = this.getEmptyCriteria();
        deleteCriteria.setIdFilter((IdFilter)new IdFilter().setIn((Collection)models.stream().map(BaseModel::getId).collect(Collectors.toList())));
        long deletedCount = ((BaseRepository)this.getRepository()).delete(deleteCriteria, user);
        this.postDelete(criteria, models, deletedCount, user);
        return deletedCount;
    }

    protected void preDelete(C criteria, List<M> models, U user) {
        for (BaseModel model : models) {
            this.preDelete(criteria, model, user);
        }
    }

    protected void preDelete(C criteria, M model, U user) {
    }

    protected void postDelete(C criteria, List<M> deletedModels, long deletedCount, U user) {
        if ((long)deletedModels.size() != deletedCount) {
            log.warn("deleting with criteria, expect delete {} item(s), but {} deleted.", (Object)deletedModels.size(), (Object)deletedCount);
        }
        for (BaseModel model : deletedModels) {
            this.postDelete(model, user);
        }
    }

    protected void postDelete(M deletedModel, U user) {
    }

    @Transactional
    public M save(D dto, U user) {
        AssertionUtils.notNull(dto, (String)"dto cannot be null.");
        return (M)((BaseModel)this.save(List.of(dto), user).get(0));
    }

    @Transactional
    public List<M> save(List<D> dtos, U user) {
        AssertionUtils.notNull(dtos, (String)"Given dtos cannot be null.");
        if (dtos.isEmpty()) {
            return Collections.emptyList();
        }
        this.preSave((D)dtos, user);
        List list = new ArrayList<M>();
        for (D dto : dtos) {
            list.add(this.onSave(dto, user));
        }
        list = ((BaseRepository)this.getRepository()).save(list, user);
        this.postSave((M)dtos, (D)list, user);
        return list.stream().map(model -> this.get(model.getId(), user)).collect(Collectors.toList());
    }

    protected abstract M onSave(D var1, U var2);

    protected void preSave(List<D> dtos, U user) {
        for (D dto : dtos) {
            this.preSave(dto, user);
        }
    }

    protected void preSave(D dto, U user) {
    }

    protected void postSave(List<D> dtos, List<M> savedModels, U user) {
        if (savedModels.size() != dtos.size()) {
            log.warn("saving dtos, expect save {} item(s), but {} saved.", (Object)dtos.size(), (Object)savedModels.size());
        }
        for (int i = 0; i < savedModels.size(); ++i) {
            this.postSave((BaseModel)savedModels.get(i), dtos.get(i), user);
        }
    }

    protected void postSave(M savedModel, D dto, U user) {
    }

    @Transactional
    public M patch(I id, Map<String, Object> patches, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        AssertionUtils.notEmpty(patches, (String)"patches cannot be empty.");
        Object entity = ((BaseRepository)this.getRepository()).get(id, user);
        if (null == entity) {
            return null;
        }
        Object pre = this.clone(entity);
        this.prePatch(pre, patches, user);
        Object patched = ((BaseRepository)this.getRepository()).patch(id, patches, user);
        this.postPatch(pre, patched, patches, user);
        return this.get(entity.getId(), user);
    }

    protected void prePatch(M previousModel, Map<String, Object> patch, U user) {
    }

    protected void postPatch(M previousModel, M patchedModel, Map<String, Object> patch, U user) {
    }

    @Transactional
    public M update(I id, D dto, U user) {
        AssertionUtils.notNull(id, (String)"id cannot be null.");
        AssertionUtils.notNull(dto, (String)"patch cannot be dto.");
        Object entity = ((BaseRepository)this.getRepository()).get(id, user);
        if (null == entity) {
            return null;
        }
        Object pre = this.clone(entity);
        this.preUpdate(pre, dto, user);
        this.onUpdate(dto, entity, user);
        Object updated = ((BaseRepository)this.getRepository()).update(entity, user);
        this.postUpdate(pre, updated, dto, user);
        return this.get(entity.getId(), user);
    }

    protected abstract void onUpdate(D var1, M var2, U var3);

    protected void preUpdate(M previousModel, D dto, U user) {
    }

    protected void postUpdate(M previousModel, M updatedModel, D dto, U user) {
    }

    protected M clone(M model) {
        return model;
    }
}

