/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.api.tree.TreeEntityCriteria;
import org.bardframework.crud.api.tree.TreeEntityModel;
import org.bardframework.crud.api.tree.TreeEntityRepository;
import org.slf4j.Logger;

public interface TreeEntityService<M extends BaseModel<I> & TreeEntityModel<M>, C extends BaseCriteria<I> & TreeEntityCriteria<I>, R extends BaseRepository<M, C, I, U> & TreeEntityRepository<M, I, U>, I, U> {
    public M getEmptyModel();

    public C getEmptyCriteria();

    public R getRepository();

    public Logger getLogger();

    default public M getTree(U user) {
        return this.toTree(this.getRepository().get(this.getEmptyCriteria(), user));
    }

    default public M getTree(I rootId, U user) {
        return this.toTree(((TreeEntityRepository)this.getRepository()).getWithChildren(rootId, user));
    }

    default public M toTree(List<M> list) {
        Map map = list.stream().collect(Collectors.toMap(rec$ -> ((BaseModel)rec$).getId(), Function.identity()));
        ArrayList<BaseModel> roots = new ArrayList<BaseModel>();
        for (BaseModel child : list) {
            if (((TreeEntityModel)((Object)child)).getParent() != null) {
                BaseModel parent = (BaseModel)map.get(((TreeEntityModel)((Object)child)).getParent().getId());
                if (null == parent) {
                    this.getLogger().warn("can't find parent {}", ((TreeEntityModel)((Object)child)).getParent());
                } else {
                    ((TreeEntityModel)((Object)parent)).addChild(child);
                }
                ((TreeEntityModel)((Object)child)).setParent(null);
                continue;
            }
            roots.add(child);
        }
        if (roots.size() == 1) {
            return (M)((BaseModel)roots.get(0));
        }
        M root = this.getEmptyModel();
        ((TreeEntityModel)root).setChildren(roots);
        return root;
    }
}

