/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import com.fasterxml.jackson.databind.JavaType;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bardframework.commons.web.WebTestHelper;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.crud.api.base.ServiceDataProvider;
import org.bardframework.crud.api.common.TestUtils;
import org.junit.jupiter.api.Test;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public interface ReadRestControllerTest<M extends BaseModel<I>, C extends BaseCriteria<I>, P extends ServiceDataProvider<M, C, ?, ?, ?, I, U>, I, U>
extends WebTestHelper {
    public P getDataProvider();

    public String BASE_URL();

    default public String GET_URL(I id) {
        return this.BASE_URL() + "/" + String.valueOf(id);
    }

    default public String FILTER_URL() {
        return this.BASE_URL() + "/filter";
    }

    public Class<M> getModelClass();

    default public JavaType getModelJavaType() {
        return this.getObjectMapper().getTypeFactory().constructType(this.getModelClass());
    }

    default public JavaType getPagedDataJavaType() {
        return this.getObjectMapper().getTypeFactory().constructParametricType(PagedData.class, new Class[]{this.getModelClass()});
    }

    default public String makeUrl(String url, C criteria, Pageable pageable) throws ReflectiveOperationException {
        return String.format("%s?page=%d&size=%d&%s", url, pageable.getPageNumber(), pageable.getPageSize(), TestUtils.toQueryParam(criteria));
    }

    @Test
    default public void testFilter() throws Exception {
        Object user = this.getDataProvider().getUser();
        Object model = this.getDataProvider().getModel(user);
        Object criteria = this.getDataProvider().getFilterCriteria(List.of(model));
        Pageable pageable = this.getDataProvider().getPageable();
        String url = this.makeUrl(this.FILTER_URL(), criteria, pageable);
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        PagedData response = (PagedData)this.execute(request, HttpStatus.OK, this.getPagedDataJavaType());
        Assertions.assertThat((long)response.getTotal()).isGreaterThan(0L);
    }

    @Test
    default public void testGET() throws Exception {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)this.GET_URL(id), (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        BaseModel result = (BaseModel)this.execute(request, HttpStatus.OK, this.getModelJavaType());
        Assertions.assertThat((Object)result.getId()).isEqualTo(id);
    }

    @Test
    default public void testGETInvalidId() throws Exception {
        Object invalidId = this.getDataProvider().getInvalidId();
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)this.GET_URL(invalidId), (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        this.execute(request, HttpStatus.NOT_FOUND, this.getModelJavaType());
    }
}

