/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.form.model.filter.IdFilter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public interface RepositoryDataProvider<M extends BaseModel<I>, C extends BaseCriteria<I>, R extends BaseRepository<M, C, I, U>, I, U> {
    public U getUser();

    public I getInvalidId();

    public M getUnsavedModel();

    public void assertEqualUpdate(M var1, M var2);

    public void makeInvalid(M var1);

    public C getEmptyCriteria();

    public R getRepository();

    public boolean isDuplicate(M var1, M var2, U var3);

    default public I getId(U user) {
        return this.getId(this.getEmptyCriteria(), this.getUnsavedModel(), user);
    }

    default public List<M> getUnsavedModels(long count, U user) {
        ArrayList<M> models = new ArrayList<M>();
        while ((long)models.size() < count) {
            M model = this.getUnsavedModel();
            if (!models.stream().noneMatch(element -> this.isDuplicate(element, model, user))) continue;
            models.add(model);
        }
        return models;
    }

    default public M getModel(U user) {
        M unsavedModel = this.getUnsavedModel();
        return this.getModel(this.getEmptyCriteria(), unsavedModel, user);
    }

    default public M getInvalidModel(U user) {
        M model = this.getModel(user);
        this.makeInvalid(model);
        return model;
    }

    default public M getUnsavedInvalidModel() {
        M unsavedModel = this.getUnsavedModel();
        this.makeInvalid(unsavedModel);
        return unsavedModel;
    }

    default public C getFilterCriteria(List<M> models) {
        C criteria = this.getEmptyCriteria();
        criteria.setIdFilter((IdFilter)new IdFilter().setIn(models.stream().map(BaseModel::getId).toList()));
        return criteria;
    }

    default public Pageable getPageable() {
        return PageRequest.of((int)1, (int)5);
    }

    default public I getId(C criteria, M unsavedModel, U user) {
        return (I)this.getModel(criteria, unsavedModel, user).getId();
    }

    default public List<I> getIds(int count, U user, I ... excludeIds) {
        return this.getModels(count, user, excludeIds).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    default public List<M> getModels(int count, U user, I ... excludeIds) {
        C criteria = this.getEmptyCriteria();
        if (excludeIds.length > 0) {
            criteria.setIdFilter((IdFilter)new IdFilter().setNotIn(List.of(excludeIds)));
        }
        this.saveNew((long)count - this.getRepository().getCount(criteria, user), user);
        return this.getRepository().get(criteria, (Pageable)PageRequest.of((int)1, (int)count), user).getData();
    }

    default public M getModel(C criteria, M unsavedModel, U user) {
        long count = this.getRepository().getCount(criteria, user);
        if (0L == count) {
            return (M)this.getRepository().save(unsavedModel, user);
        }
        return (M)((BaseModel)this.getRepository().get(criteria, (Pageable)PageRequest.of((int)RandomUtils.nextInt((int)1, (int)((int)count)), (int)1), user).getData().get(0));
    }

    @Transactional
    default public List<M> saveNew(long count, U user) {
        ArrayList<BaseModel> unsavedModels = new ArrayList<BaseModel>();
        for (long i = 0L; i < count; ++i) {
            unsavedModels.add(this.getRepository().save(this.getUnsavedModel(), user));
        }
        return unsavedModels;
    }

    default public M getOrSave(M unsavedModel, U user, Function<M, Boolean> validateFunction) {
        M model = this.getModel(validateFunction, user);
        if (null == model) {
            return (M)this.getRepository().save(unsavedModel, user);
        }
        return model;
    }

    default public M getModel(Function<M, Boolean> validateFunction, U user) {
        C criteria = this.getEmptyCriteria();
        long count = this.getRepository().getCount(criteria, user);
        if (count == 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < count) {
            BaseModel model = (BaseModel)this.getRepository().get(criteria, (Pageable)PageRequest.of((int)i, (int)1), user).getData().get(0);
            if (validateFunction.apply(model).booleanValue()) {
                return (M)model;
            }
            ++i;
        }
        return null;
    }

    default public boolean isExist(C criteria, U user) {
        return this.getRepository().isExist(criteria, user);
    }

    default public void assertEqualSave(M first, M second) {
        this.assertEqualUpdate(first, second);
    }
}

