/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.crud.api.base.BaseService;
import org.bardframework.crud.api.base.RepositoryDataProvider;
import org.springframework.transaction.annotation.Transactional;

public interface ServiceDataProvider<M extends BaseModel<I>, C extends BaseCriteria<I>, D, S extends BaseService<M, C, D, R, I, U>, R extends BaseRepository<M, C, I, U>, I, U>
extends RepositoryDataProvider<M, C, R, I, U> {
    public S getService();

    @Override
    public void makeInvalid(D var1);

    public D getDto();

    @Override
    public void assertEqualUpdate(M var1, D var2);

    @Override
    default public R getRepository() {
        return (R)((BaseRepository)this.getService().getRepository());
    }

    @Override
    default public M getUnsavedModel() {
        return this.toModel(this.getDto());
    }

    default public List<D> getUnsavedDtos(long count, U user) {
        ArrayList<D> models = new ArrayList<D>();
        while ((long)models.size() < count) {
            D dto = this.getDto();
            if (!models.stream().noneMatch(element -> this.isDuplicate((D)element, dto, user))) continue;
            models.add(dto);
        }
        return models;
    }

    @Override
    default public boolean isDuplicate(D first, D second, U user) {
        return this.isDuplicate((D)this.toModel(first), (D)this.toModel(second), user);
    }

    default public M toModel(D dto) {
        return (M)this.getService().onSave(dto, this.getUser());
    }

    default public D getInvalidDto() {
        D dto = this.getDto();
        this.makeInvalid(dto);
        return dto;
    }

    @Override
    default public void assertEqualSave(M model, D dto) {
        this.assertEqualUpdate(model, dto);
    }

    @Override
    @Transactional
    default public List<M> saveNew(long count, U user) {
        ArrayList<BaseModel> unsavedModels = new ArrayList<BaseModel>();
        for (long i = 0L; i < count; ++i) {
            unsavedModels.add(this.getService().save(this.getDto(), user));
        }
        return unsavedModels;
    }

    @Override
    default public M getOrSave(D unsavedDto, U user, Function<M, Boolean> validateFunction) {
        M model = this.getModel(validateFunction, user);
        if (null == model) {
            return (M)this.getService().save(unsavedDto, user);
        }
        return null;
    }
}

