/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.crud.api.base;

import com.fasterxml.jackson.databind.JavaType;
import org.assertj.core.api.Assertions;
import org.bardframework.commons.web.WebTestHelper;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.ServiceDataProvider;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public interface WriteRestControllerTest<M extends BaseModel<I>, D, P extends ServiceDataProvider<M, ?, D, ?, ?, I, U>, I, U>
extends WebTestHelper {
    public String BASE_URL();

    public P getDataProvider();

    public Class<M> getModelClass();

    default public String GET_URL(I id) {
        return this.BASE_URL() + "/" + String.valueOf(id);
    }

    default public String DELETE_URL(I id) {
        return this.BASE_URL() + "/" + String.valueOf(id);
    }

    default public String SAVE_URL() {
        return this.BASE_URL();
    }

    default public String UPDATE_URL(I id) {
        return this.BASE_URL() + "/" + String.valueOf(id);
    }

    default public JavaType getModelJavaType() {
        return this.getObjectMapper().getTypeFactory().constructType(this.getModelClass());
    }

    default public JavaType getLongJavaType() {
        return this.getObjectMapper().getTypeFactory().constructType(Long.class);
    }

    @Test
    default public void testSAVE() throws Exception {
        Object dto = this.getDataProvider().getDto();
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post((String)this.SAVE_URL(), (Object[])new Object[0]).content(this.getObjectMapper().writeValueAsBytes(dto)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        BaseModel result = (BaseModel)this.execute(request, HttpStatus.OK, this.getModelJavaType());
        Assertions.assertThat((Object)result.getId()).isNotNull();
        this.getDataProvider().assertEqualSave((BaseModel)result, dto);
    }

    @Test
    default public void testSAVEUnsuccessful() throws Exception {
        Object invalidDto = this.getDataProvider().getInvalidDto();
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post((String)this.SAVE_URL(), (Object[])new Object[0]).content(this.getObjectMapper().writeValueAsBytes(invalidDto)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        MvcResult response = this.execute(request);
        Assertions.assertThat((int)response.getResponse().getStatus()).isEqualTo(HttpStatus.NOT_ACCEPTABLE.value());
    }

    @Test
    default public void testUPDATE() throws Exception {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        Object dto = this.getDataProvider().getDto();
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.put((String)this.UPDATE_URL(id), (Object[])new Object[0]).content(this.getObjectMapper().writeValueAsBytes(dto)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        BaseModel response = (BaseModel)this.execute(request, HttpStatus.OK, this.getModelJavaType());
        this.getDataProvider().assertEqualUpdate((BaseModel)response, dto);
    }

    @Test
    default public void testUPDATEUnsuccessful() throws Exception {
        Object user = this.getDataProvider().getUser();
        Object id = this.getDataProvider().getId(user);
        Object invalidDto = this.getDataProvider().getInvalidDto();
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.put((String)this.UPDATE_URL(id), (Object[])new Object[0]).content(this.getObjectMapper().writeValueAsBytes(invalidDto)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON});
        MvcResult response = this.execute(request);
        Assertions.assertThat((int)response.getResponse().getStatus()).isEqualTo(HttpStatus.NOT_ACCEPTABLE.value());
    }

    @Test
    default public void testDELETE() throws Exception {
        Object user = this.getDataProvider().getUser();
        BaseModel savedModel = (BaseModel)this.getDataProvider().saveNew(1L, user).get(0);
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.delete((String)this.DELETE_URL(savedModel.getId()), (Object[])new Object[0]);
        this.execute(request, HttpStatus.OK, this.getLongJavaType());
        MvcResult response = this.execute(MockMvcRequestBuilders.get((String)this.GET_URL(savedModel.getId()), (Object[])new Object[0]));
        Assertions.assertThat((int)response.getResponse().getStatus()).isEqualTo(HttpStatus.NOT_FOUND.value());
    }

    @Test
    default public void testDELETEUnsuccessful() throws Exception {
        Object invalidId = this.getDataProvider().getInvalidId();
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.delete((String)this.DELETE_URL(invalidId), (Object[])new Object[0]);
        this.execute(request, HttpStatus.NOT_FOUND, this.getLongJavaType());
    }
}

