/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.crud;

import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import io.github.jhipster.service.filter.Filter;
import io.github.jhipster.service.filter.RangeFilter;
import io.github.jhipster.service.filter.StringFilter;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import org.bardframework.base.crud.BaseCriteriaAbstract;
import org.bardframework.base.crud.BaseModelAbstract;
import org.bardframework.base.crud.BaseRepository;
import org.bardframework.base.crud.ReadExtendedRepositoryQdslSql;
import org.bardframework.base.crud.WriteExtendedRepositoryQdslSql;
import org.bardframework.base.filter.IdFilter;
import org.bardframework.base.util.PageableExecutionUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.bardframework.commons.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseRepositoryQdslSqlAbstract<M extends BaseModelAbstract<I>, C extends BaseCriteriaAbstract<I>, I extends Comparable<? super I>, U>
implements BaseRepository<M, C, I, U> {
    private static final int DEFAULT_SIZE = 20;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final Class<M> modelClazz;
    protected final Class<C> criteriaClazz;
    @Autowired
    private SQLQueryFactory queryFactory;

    public BaseRepositoryQdslSqlAbstract() {
        ParameterizedType parameterizedType = null;
        for (Class<?> targetClazz = this.getClass(); (null == parameterizedType || parameterizedType.getActualTypeArguments().length < 2) && null != targetClazz; targetClazz = targetClazz.getSuperclass()) {
            parameterizedType = targetClazz.getGenericSuperclass() instanceof ParameterizedType ? (ParameterizedType)targetClazz.getGenericSuperclass() : null;
        }
        try {
            this.modelClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.criteriaClazz = (Class)parameterizedType.getActualTypeArguments()[1];
        }
        catch (Exception e) {
            this.LOGGER.debug("can't determine class from generic type!", (Throwable)e);
            throw new IllegalArgumentException("can't determine class from generic type!", e);
        }
    }

    protected abstract <T> SQLQuery<T> setCriteria(C var1, SQLQuery<T> var2, U var3);

    protected abstract RelationalPathBase<?> getEntity();

    protected abstract QBean<M> getQBean();

    protected abstract <T extends StoreClause<T>> T toClause(T var1, M var2, U var3);

    protected abstract M setIdentifier(M var1, U var2);

    private static boolean isUnpaged(Pageable pageable) {
        return pageable.isUnpaged();
    }

    public M getEmptyModel() {
        try {
            return (M)((BaseModelAbstract)this.modelClazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOGGER.error("can't instantiate model class using empty constructor {}", this.modelClazz, (Object)e);
            throw new IllegalArgumentException("can't instantiate model class using empty constructor" + this.modelClazz, e);
        }
    }

    public C getEmptyCriteria() {
        BaseCriteriaAbstract criteria;
        try {
            criteria = (BaseCriteriaAbstract)this.criteriaClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOGGER.error("can't instantiate criteria class using empty constructor {}", this.criteriaClazz, (Object)e);
            throw new IllegalArgumentException("can't instantiate criteria class using empty constructor" + this.criteriaClazz, e);
        }
        return (C)criteria;
    }

    protected <T extends StoreClause<T>> T fillClause(T clause, M model, U user) {
        clause = this.toClause(clause, model, user);
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!WriteExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((WriteExtendedRepositoryQdslSql)((Object)this)).process(clause, model, user);
        }
        return clause;
    }

    @Transactional
    public M save(M model, U user) {
        return (M)((BaseModelAbstract)this.save(Collections.singletonList(model), user).get(0));
    }

    @Transactional
    public List<M> save(List<M> models, U user) {
        if (CollectionUtils.isEmpty(models)) {
            return models;
        }
        SQLInsertClause insertClause = this.getQueryFactory().insert(this.getEntity());
        models.forEach(model -> {
            this.setIdentifier(model, user);
            AssertionUtils.notNull((Object)model.getId(), (String)"model identifier is not provided in 'setIdentifier' method");
            insertClause.set((Path)this.getIdentifierPath(), (Object)model.getId());
            this.fillClause(insertClause, model, user);
            insertClause.addBatch();
        });
        long affectedRowsCount = insertClause.execute();
        if ((long)models.size() != affectedRowsCount) {
            this.LOGGER.warn("expect insert '{}' row, but '{}' row(s) inserted.", (Object)models.size(), (Object)affectedRowsCount);
        }
        return models;
    }

    @Transactional
    public M update(M model, U user) {
        SQLUpdateClause updateClause = (SQLUpdateClause)this.getQueryFactory().update(this.getEntity()).where((Predicate)this.getIdentifierPath().eq((Object)model.getId()));
        long affectedRowsCount = (updateClause = this.fillClause(updateClause, model, user)).execute();
        if (1L != affectedRowsCount) {
            throw new IllegalStateException("expect affect one row, but " + affectedRowsCount + " row(s) updated.");
        }
        return model;
    }

    public abstract <T extends ComparableExpression<I>> T getIdentifierPath();

    @Transactional(readOnly=true)
    public M get(I identifier, U user) {
        AssertionUtils.notNull(identifier, (String)"Given Identifier cannot be null.");
        C criteria = this.getEmptyCriteria();
        criteria.setId((IdFilter)new IdFilter().setEquals(identifier));
        return this.getOne(criteria, user);
    }

    @Transactional(readOnly=true)
    public List<M> get(List<I> ids, U user) {
        AssertionUtils.notNull(ids, (String)"Given Identifiers cannot be null.");
        C criteria = this.getEmptyCriteria();
        criteria.setId((IdFilter)new IdFilter().setIn(ids));
        return this.get(criteria, user);
    }

    public SQLQuery<?> prepareQuery(C criteria, U user) {
        SQLQuery query = this.getQueryFactory().query();
        query.from(this.getEntity());
        query = this.setJoins(query, user);
        query = this.setCriteria(criteria, query, user);
        if (null != criteria.getId()) {
            this.buildQuery(query, (Filter)criteria.getId(), (ComparableExpression)this.getIdentifierPath());
        }
        for (Class<?> clazz : this.getClass().getInterfaces()) {
            if (!ReadExtendedRepositoryQdslSql.class.isAssignableFrom(clazz)) continue;
            ((ReadExtendedRepositoryQdslSql)((Object)this)).process(criteria, query, user);
        }
        this.setOrders(query, criteria, user);
        return query;
    }

    @Transactional(readOnly=true)
    public Page<M> get(C criteria, Pageable pageable, U user) {
        AssertionUtils.notNull(criteria, (String)"null criteria not acceptable");
        SQLQuery<?> query = this.prepareQuery(criteria, user);
        long count = query.fetchCount();
        if (0L > count) {
            return Page.empty();
        }
        query = this.prepareQuery(criteria, user);
        return BaseRepositoryQdslSqlAbstract.isUnpaged(pageable) ? new Page<M>(this.getList(query)) : this.readPage(query, pageable, count, user);
    }

    private List<M> getList(SQLQuery<?> query) {
        return query.select(this.getQBean()).fetch();
    }

    protected Page<M> readPage(SQLQuery<?> query, Pageable pageable, long count, U user) {
        if (pageable.isPaged()) {
            query = this.setPageAndSize(query, pageable, user);
        }
        return PageableExecutionUtils.getPage(this.getList(query), (Pageable)pageable, (long)count);
    }

    public <T> SQLQuery<T> setPageAndSize(SQLQuery<T> query, Pageable pageable, U user) {
        query.limit(pageable.getOffset() < 1L ? 20L : (long)((int)pageable.getOffset()));
        query.offset((long)(Math.max(pageable.getPageNumber(), 0) * pageable.getPageSize()));
        return query;
    }

    @Transactional(readOnly=true)
    public long getCount(C criteria, U user) {
        return this.prepareQuery(criteria, user).fetchCount();
    }

    @Transactional(readOnly=true)
    public boolean isExist(C criteria, U user) {
        return this.getCount(criteria, user) > 0L;
    }

    @Transactional(readOnly=true)
    public boolean isNotExist(C criteria, U user) {
        return this.getCount(criteria, user) == 0L;
    }

    @Transactional
    public long delete(I id, U user) {
        AssertionUtils.notNull(id, (String)"id should not be null.");
        return this.delete((C)Collections.singletonList(id), user);
    }

    @Transactional
    public long delete(List<I> ids, U user) {
        AssertionUtils.notNull(ids, (String)"ids should not be null.");
        C criteria = this.getEmptyCriteria();
        criteria.setId((IdFilter)new IdFilter().setIn(ids));
        return this.delete(criteria, user);
    }

    @Transactional
    public long delete(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Criteria object should not be null.");
        return ((SQLDeleteClause)this.getQueryFactory().delete(this.getEntity()).where((Predicate)this.getIdentifierPath().in(this.getIds(criteria, user)))).execute();
    }

    @Transactional
    public long directDelete(List<I> ids, U user) {
        AssertionUtils.notEmpty(ids, (String)"ids should not be empty.");
        return ((SQLDeleteClause)this.getQueryFactory().delete(this.getEntity()).where((Predicate)this.getIdentifierPath().in(ids))).execute();
    }

    @Transactional(readOnly=true)
    public List<I> getIds(C criteria, U user) {
        return this.prepareQuery(criteria, user).select(this.getIdentifierPath()).fetch();
    }

    @Transactional(readOnly=true)
    public List<M> get(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        return this.prepareQuery(criteria, user).select(this.getQBean()).fetch();
    }

    @Transactional(readOnly=true)
    public M getOne(C criteria, U user) {
        AssertionUtils.notNull(criteria, (String)"Given criteria cannot be null");
        return (M)((BaseModelAbstract)this.prepareQuery(criteria, user).select(this.getQBean()).fetchOne());
    }

    protected <T> SQLQuery<T> setJoins(SQLQuery<T> query, U user) {
        return query;
    }

    public <R> SQLQuery<R> setOrders(SQLQuery<R> query, C criteria, U user) {
        return query;
    }

    public SQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    protected <I extends Comparable<? super I>> I safeFetchId(BaseModelAbstract<I> model) {
        return (I)(null == model ? null : model.getId());
    }

    protected <T, X extends Comparable<? super X>> SQLQuery<T> buildQuery(SQLQuery<T> query, Filter<X> filter, ComparableExpression<X> expression) {
        if (filter.getEquals() != null) {
            return (SQLQuery)query.where((Predicate)expression.eq(filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return (SQLQuery)query.where((Predicate)expression.in(filter.getIn()));
        }
        if (filter.getNotEquals() != null) {
            return (SQLQuery)query.where((Predicate)expression.ne(filter.getNotEquals()));
        }
        if (filter.getNotIn() != null) {
            return (SQLQuery)query.where((Predicate)expression.notIn(filter.getNotIn()));
        }
        if (filter.getSpecified() != null) {
            if (filter.getSpecified().booleanValue()) {
                return (SQLQuery)query.where((Predicate)expression.isNotNull());
            }
            return (SQLQuery)query.where((Predicate)expression.isNull());
        }
        return query;
    }

    protected <T> SQLQuery<T> buildQuery(SQLQuery<T> query, StringFilter filter, StringExpression expression) {
        if (filter.getEquals() != null) {
            return (SQLQuery)query.where((Predicate)expression.eq(filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return (SQLQuery)query.where((Predicate)expression.in(filter.getIn()));
        }
        if (filter.getContains() != null) {
            return (SQLQuery)query.where((Predicate)expression.likeIgnoreCase("%" + filter.getContains() + "%"));
        }
        if (filter.getDoesNotContain() != null) {
            return (SQLQuery)query.where((Predicate)expression.notLike(filter.getDoesNotContain()));
        }
        if (filter.getNotEquals() != null) {
            return (SQLQuery)query.where((Predicate)expression.ne(filter.getNotEquals()));
        }
        if (filter.getNotIn() != null) {
            return (SQLQuery)query.where((Predicate)expression.notIn(filter.getNotIn()));
        }
        if (filter.getSpecified() != null) {
            if (filter.getSpecified().booleanValue()) {
                return (SQLQuery)query.where((Predicate)expression.isNotNull());
            }
            return (SQLQuery)query.where((Predicate)expression.isNull());
        }
        return query;
    }

    protected <T, X extends Comparable<? super X>> SQLQuery<T> buildQuery(SQLQuery<T> query, RangeFilter<X> filter, ComparableExpression<X> expression) {
        query = this.buildQueryInternal(query, filter, (ComparableExpressionBase<X>)expression);
        if (filter.getGreaterThan() != null) {
            query.where((Predicate)expression.gt(filter.getGreaterThan()));
        }
        if (filter.getGreaterThanOrEqual() != null) {
            query.where((Predicate)expression.goe(filter.getGreaterThanOrEqual()));
        }
        if (filter.getLessThan() != null) {
            query.where((Predicate)expression.lt(filter.getLessThan()));
        }
        if (filter.getLessThanOrEqual() != null) {
            query.where((Predicate)expression.loe(filter.getLessThanOrEqual()));
        }
        return query;
    }

    private <T, X extends Comparable<? super X>> SQLQuery<T> buildQueryInternal(SQLQuery<T> query, RangeFilter<X> filter, ComparableExpressionBase<X> expression) {
        if (filter.getEquals() != null) {
            return (SQLQuery)query.where((Predicate)expression.eq(filter.getEquals()));
        }
        if (filter.getIn() != null) {
            return (SQLQuery)query.where((Predicate)expression.in(filter.getIn()));
        }
        if (filter.getSpecified() != null) {
            if (filter.getSpecified().booleanValue()) {
                query.where((Predicate)expression.isNotNull());
            } else {
                query.where((Predicate)expression.isNull());
            }
        }
        if (filter.getNotEquals() != null) {
            query.where((Predicate)expression.ne(filter.getNotEquals()));
        } else if (filter.getNotIn() != null) {
            query.where((Predicate)expression.notIn(filter.getNotIn()));
        }
        return query;
    }

    protected <T, X extends Number> SQLQuery<T> buildQuery(SQLQuery<T> query, RangeFilter<X> filter, NumberExpression<X> expression) {
        this.buildQueryInternal(query, filter, (ComparableExpressionBase<X>)expression);
        if (filter.getGreaterThan() != null) {
            query.where((Predicate)expression.gt((Number)((Object)filter.getGreaterThan())));
        }
        if (filter.getGreaterThanOrEqual() != null) {
            query.where((Predicate)expression.goe((Number)((Object)filter.getGreaterThanOrEqual())));
        }
        if (filter.getLessThan() != null) {
            query.where((Predicate)expression.lt((Number)((Object)filter.getLessThan())));
        }
        if (filter.getLessThanOrEqual() != null) {
            query.where((Predicate)expression.loe((Number)((Object)filter.getLessThanOrEqual())));
        }
        return query;
    }
}

