/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.base.searchable;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bardframework.base.crud.BaseCriteria;
import org.bardframework.base.crud.BaseModelAbstract;
import org.bardframework.base.crud.ReadExtendedRepositoryQdslSql;
import org.bardframework.base.searchable.SearchableCriteria;
import org.bardframework.base.searchable.SearchableEntityRepository;
import org.bardframework.commons.reflection.ReflectionUtils;
import org.bardframework.commons.utils.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public interface SearchableEntityRepositoryQdslSql<M extends BaseModelAbstract<I>, C extends BaseCriteria<I> & SearchableCriteria, I extends Comparable<? super I>, U>
extends SearchableEntityRepository<M, C, I, U>,
ReadExtendedRepositoryQdslSql<C, I, U> {
    public StringPath[] getSearchPaths();

    public M getEmptyModel();

    public Path<?> getIdentifierPath();

    public <T> SQLQuery<T> setPageAndSize(SQLQuery<T> var1, Pageable var2, U var3);

    public SQLQuery<?> prepareQuery(C var1, U var2);

    @Transactional(readOnly=true)
    default public List<M> search(C criteria, Pageable pageable, U user) {
        List<Path<?>> selectPaths = this.getSelectOnSearchPaths();
        selectPaths.add(this.getIdentifierPath());
        SQLQuery query = this.prepareQuery(criteria, user).select((Expression[])selectPaths.toArray(new Path[0]));
        this.setPageAndSize(query, pageable, user);
        ArrayList<M> models = new ArrayList<M>();
        for (Tuple tuple : query.fetch()) {
            M model = this.getEmptyModel();
            for (Path<?> searchPath : selectPaths) {
                try {
                    ReflectionUtils.setValue(model, (String)this.getStringPath(searchPath), (Object)tuple.get(searchPath));
                }
                catch (Exception e) {
                    throw new IllegalStateException("can't set value", e);
                }
            }
            models.add(model);
        }
        return models;
    }

    default public List<Path<?>> getSelectOnSearchPaths() {
        return new ArrayList<StringPath>(Arrays.asList(this.getSearchPaths()));
    }

    default public String getStringPath(Path<?> path) {
        String stringPath = path.getMetadata().getElement().toString();
        if (!path.getRoot().equals(path.getMetadata().getParent())) {
            stringPath = path.getMetadata().getParent().getMetadata().getElement() + "." + stringPath;
        }
        return stringPath;
    }

    @Override
    default public <T> SQLQuery<T> process(C criteria, SQLQuery<T> query, U user) {
        if (StringUtils.hasNotText((String)((SearchableCriteria)criteria).getQuery())) {
            return query;
        }
        BooleanExpression searchExpression = this.getSearchPaths()[0].like("%" + ((SearchableCriteria)criteria).getQuery() + "%", ' ');
        for (int i = 1; i < this.getSearchPaths().length; ++i) {
            searchExpression = searchExpression.or((Predicate)this.getSearchPaths()[i].like("%" + ((SearchableCriteria)criteria).getQuery() + "%", ' '));
        }
        query.where((Predicate)searchExpression);
        return query;
    }
}

