/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.field.FieldTemplate;
import org.bardframework.table.TableTemplate;
import org.bardframework.table.TableUtils;
import org.bardframework.table.header.HeaderTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class TableModeCheckUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableModeCheckUtils.class);

    public static void checkDefinitionValidity(TableTemplate template, Map<String, String> args, Locale locale) {
        ((ClassAssert)Assertions.assertThat((Class)template.getModelClass()).withFailMessage("model class of [%s] table not set", new Object[]{template.getName()})).isNotNull();
        for (HeaderTemplate headerTemplate : template.getHeaderTemplates()) {
            ((AbstractStringAssert)Assertions.assertThat((String)headerTemplate.getName()).withFailMessage("some headers name of table [%s] is empty.", new Object[]{template.getName()})).isNotEmpty();
            try {
                ReflectionUtils.getGetterMethod((Class)template.getModelClass(), (String)headerTemplate.getName());
            }
            catch (NoSuchMethodException e) {
                log.error("error get getter of [{}.{}]", new Object[]{template.getModelClass(), headerTemplate.getName(), e});
                Assertions.fail((String)(headerTemplate.getName() + " field not exist in " + template.getModelClass().getName()));
            }
            String headerTitle = TableUtils.getHeaderStringValue((TableTemplate)template, (HeaderTemplate)headerTemplate, (String)"title", (Locale)locale, Map.of(), (String)headerTemplate.getTitle());
            ((AbstractStringAssert)Assertions.assertThat((String)headerTitle).withFailMessage("header title [%s.%s] in locale [%s] is not set", new Object[]{template.getName(), headerTemplate.getName(), locale.getLanguage()})).isNotEmpty();
        }
        TableModeCheckUtils.checkFormModelValidity(Map.of(), args, template, template.getFilterFormTemplate());
        TableModeCheckUtils.checkFormModelValidity(Map.of(), args, template, template.getSaveFormTemplate());
        TableModeCheckUtils.checkFormModelValidity(Map.of(), args, template, template.getUpdateFormTemplate());
    }

    private static void checkFormModelValidity(Map<String, String> values, Map<String, String> args, TableTemplate tableTemplate, FormTemplate formTemplate) {
        if (null == formTemplate) {
            return;
        }
        ((ClassAssert)Assertions.assertThat((Class)formTemplate.getDtoClass()).withFailMessage("dto class of [%s] forms not set", new Object[]{tableTemplate.getName()})).isNotNull();
        try {
            ReflectionUtils.newInstance((Class)formTemplate.getDtoClass());
        }
        catch (Exception e) {
            log.error("error instantiating class: " + String.valueOf(formTemplate.getDtoClass()), (Throwable)e);
            Assertions.fail((String)"can't instantiate class [%s], maybe default constructor not exist", (Object[])new Object[]{formTemplate.getDtoClass()});
        }
        for (FieldTemplate formField : formTemplate.getFieldTemplates(values, args)) {
            TableModeCheckUtils.checkSetter(formTemplate.getDtoClass(), formField.getName());
        }
    }

    private static void checkSetter(Class<?> clazz, String property) {
        Field field = ReflectionUtils.findField(clazz, (String)property);
        if (null == field) {
            Assertions.fail((String)(property + " field not exist in " + clazz.getName()));
        }
    }

    public static List<String> checkI18nExistence(TableTemplate template, Map<String, String> args, Locale locale) {
        ArrayList<String> notExistence = new ArrayList<String>();
        if (TableModeCheckUtils.isNotExist(template.getTitle(), template.getMessageSource(), locale)) {
            notExistence.add(template.getTitle());
        }
        if (TableModeCheckUtils.isNotExist(template.getDescription(), template.getMessageSource(), locale)) {
            notExistence.add(template.getDescription());
        }
        template.getHeaderTemplates().forEach(header -> notExistence.addAll(TableModeCheckUtils.checkI18nExistence(header, template.getMessageSource(), locale)));
        notExistence.addAll(TableModeCheckUtils.checkI18nExistence(template.getFilterFormTemplate(), Map.of(), args, locale));
        notExistence.addAll(TableModeCheckUtils.checkI18nExistence(template.getSaveFormTemplate(), Map.of(), args, locale));
        notExistence.addAll(TableModeCheckUtils.checkI18nExistence(template.getUpdateFormTemplate(), Map.of(), args, locale));
        return notExistence;
    }

    private static List<String> checkI18nExistence(FieldTemplate<?> template, MessageSource messageSource, Locale locale) {
        return new ArrayList<String>();
    }

    private static List<String> checkI18nExistence(FormTemplate template, Map<String, String> values, Map<String, String> args, Locale locale) {
        if (null == template) {
            return Collections.emptyList();
        }
        ArrayList<String> notExistence = new ArrayList<String>();
        template.getFieldTemplates(values, args).forEach(field -> notExistence.addAll(TableModeCheckUtils.checkI18nExistence(field, template.getMessageSource(), locale)));
        return notExistence;
    }

    private static List<String> checkI18nExistence(HeaderTemplate<?, ?, ?> headerTemplate, MessageSource messageSource, Locale locale) {
        ArrayList<String> notExistence = new ArrayList<String>();
        if (TableModeCheckUtils.isNotExist(headerTemplate.getTitle(), messageSource, locale)) {
            notExistence.add(headerTemplate.getTitle());
        }
        return notExistence;
    }

    private static boolean isNotExist(String key, MessageSource messageSource, Locale locale) {
        if (null == key) {
            return false;
        }
        try {
            String message = messageSource.getMessage(key, new Object[0], locale);
            return StringUtils.isEmpty((CharSequence)message);
        }
        catch (NoSuchMessageException e) {
            log.debug("message key [{}] not exist for locale [{}]", (Object)key, (Object)locale);
            return true;
        }
    }
}

