/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import org.bardframework.crud.api.base.BaseCriteria;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseService;
import org.bardframework.crud.api.base.PagedData;
import org.bardframework.table.ExcelUtils;
import org.bardframework.table.TableData;
import org.bardframework.table.TableModel;
import org.bardframework.table.TableTemplate;
import org.bardframework.table.TableUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

public interface TableModelRestController<M extends BaseModel<?>, C extends BaseCriteria<?>, S extends BaseService<M, C, ?, ?, ?, U>, U> {
    public static final String APPLICATION_OOXML_SHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String TABLE_GET_URL = "table";
    public static final String TABLE_FILTER_URL = "table/filter";
    public static final String TABLE_EXPORT_URL = "table/export";

    public TableTemplate getTableTemplate();

    public S getService();

    public U getUser();

    public boolean isRtl(Locale var1, U var2);

    public String getExportFileName(String var1, Locale var2, U var3);

    @GetMapping(path={"table"}, produces={"application/json"})
    default public TableModel getTableModel(Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        return TableUtils.toTable((TableTemplate)this.getTableTemplate(), Map.of(), (Locale)locale, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }

    @GetMapping(path={"table/filter"}, produces={"application/json"})
    default public TableData getTableData(@ModelAttribute C criteria, Pageable page, Locale locale) {
        U user = this.getUser();
        PagedData pagedData = this.getService().get(criteria, page, user);
        return ExcelUtils.toTableData(pagedData, this.getTableTemplate(), locale, false, user);
    }

    @GetMapping(path={"table/export"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    default public void exportTable(@ModelAttribute C criteria, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        U user = this.getUser();
        PagedData pagedData = this.getService().get(criteria, (Pageable)QPageRequest.of((int)1, (int)Integer.MAX_VALUE), user);
        TableData tableData = ExcelUtils.toTableData(pagedData, this.getTableTemplate(), locale, true, user);
        String fileName = this.getExportFileName(APPLICATION_OOXML_SHEET, locale, user);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            httpResponse.setContentType(APPLICATION_OOXML_SHEET);
            httpResponse.addHeader("Content-Disposition", "attachment;filename=\"%s\"".formatted(fileName));
            ExcelUtils.generateExcel(this.getTableTemplate(), tableData, (OutputStream)outputStream, locale, this.isRtl(locale, user), httpRequest, httpResponse);
        }
    }
}

