/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.repository;

import java.time.Duration;
import lombok.Generated;
import org.bardframework.commons.redis.DataManager;
import org.bardframework.commons.redis.DataManagerRedisImpl;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.flow.FlowData;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.repository.FlowDataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class FlowDataRepositoryRedis<D extends FlowData>
implements FlowDataRepository<D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowDataRepositoryRedis.class);
    private final DataManager cache;
    private final Duration expiration;

    public FlowDataRepositoryRedis(RedisTemplate<String, Object> redisTemplate, long expirationMs) {
        this.cache = new DataManagerRedisImpl(redisTemplate);
        this.expiration = Duration.ofMillis(expirationMs);
    }

    public boolean contains(String token) {
        return this.cache.isExist(token);
    }

    public void put(String token, D data) {
        this.cache.putAsJson(token, data, this.expiration);
    }

    public D get(String token) throws InvalidateFlowException {
        FlowData data = (FlowData)this.cache.getFromJson(token, this.getDataClass());
        if (null != data) {
            return (D)data;
        }
        throw new InvalidateFlowException(token, "no data exist for token");
    }

    public void remove(String token) {
        this.cache.remove(token);
    }

    protected Class<D> getDataClass() {
        try {
            return ReflectionUtils.getGenericArgType(this.getClass(), (int)0);
        }
        catch (Exception e) {
            return FlowData.class;
        }
    }
}

