/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.captcha;

import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.captcha.GeneratedCaptcha;
import org.bardframework.flow.form.field.input.otp.OtpFieldTemplate;
import org.bardframework.flow.form.field.input.otp.OtpGenerator;
import org.bardframework.form.field.input.CaptchaField;

public class CaptchaFieldTemplate
extends OtpFieldTemplate<CaptchaField, GeneratedCaptcha> {
    private static final String ANSWER_KEY = "X_ANSWER_CAPTCHA";

    public CaptchaFieldTemplate(String name, OtpGenerator<GeneratedCaptcha> otpGenerator) {
        super(name, otpGenerator, 1);
    }

    @Override
    protected void send(String flowToken, Map<String, String> flowData, GeneratedCaptcha generatedCaptcha, Locale locale, HttpServletResponse httpResponse) throws Exception {
        flowData.put(ANSWER_KEY, generatedCaptcha.getValue());
        IOUtils.write((String)("data:image/png;base64," + Base64.getEncoder().encodeToString(generatedCaptcha.getImage())), (OutputStream)httpResponse.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        httpResponse.setHeader("Content-Type", "image/png");
        httpResponse.setStatus(200);
    }

    @Override
    protected boolean isValidOtp(String flowToken, String captcha, Map<String, String> flowData) throws Exception {
        String expectedAnswer = flowData.remove(ANSWER_KEY);
        if (StringUtils.isBlank((CharSequence)expectedAnswer)) {
            this.log.debug("captcha answer in flow data is blank, flow token: [{}]", (Object)flowToken);
            return false;
        }
        return expectedAnswer.equalsIgnoreCase(captcha);
    }

    @Override
    protected String getResendAction() {
        return "captcha-resend";
    }

    public int getValidationOrder() {
        return Integer.MIN_VALUE;
    }
}

