/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.commons.web.utils.WebUtils;
import org.bardframework.flow.FlowData;
import org.bardframework.flow.FlowHandler;
import org.bardframework.flow.FlowResponse;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.form.FlowFormTemplate;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.flow.form.field.input.FlowInputFieldTemplate;
import org.bardframework.flow.repository.FlowDataRepository;
import org.bardframework.form.BardForm;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.FormUtils;
import org.bardframework.form.field.input.InputFieldTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowHandlerAbstract<D extends FlowData>
implements FlowHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FlowHandlerAbstract.class);
    protected final FlowDataRepository<D> flowDataRepository;
    protected final List<FlowFormTemplate> forms;
    protected List<FormProcessor> preProcessors = new ArrayList<FormProcessor>();
    protected List<FormProcessor> postProcessors = new ArrayList<FormProcessor>();
    protected Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();

    public FlowHandlerAbstract(FlowDataRepository<D> flowDataRepository, List<FlowFormTemplate> forms) {
        this.flowDataRepository = flowDataRepository;
        this.forms = forms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse<String> start(Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)ReflectionUtils.newInstance((Class)ReflectionUtils.getGenericArgType(this.getClass(), (int)0));
        String flowToken = this.generateFlowToken();
        flowData.setLocale(locale);
        this.getFlowDataRepository().put(flowToken, flowData);
        try {
            this.process(this.getPreProcessors(), flowToken, flowData, Map.of(), httpRequest, httpResponse);
            FlowResponse<String> response = this.processNextForm(flowToken, flowData, Map.of(), flowToken, httpRequest, httpResponse);
            flowData.setNextStepIndex(flowData.getNextStepIndex() + 1);
            FlowResponse<String> flowResponse = response;
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    @Override
    public FlowResponse<String> submit(String flowToken, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        FlowFormTemplate currentFormTemplate = this.getCurrentFormTemplate(flowData);
        this.fillFlowData(flowData.getData(), formData, currentFormTemplate, flowData.getLocale(), httpRequest);
        try {
            this.process(currentFormTemplate.getPostProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            FlowResponse<String> response = this.processNextForm(flowToken, flowData, formData, null, httpRequest, httpResponse);
            flowData.setNextStepIndex(flowData.getNextStepIndex() + 1);
            FlowResponse<String> flowResponse = response;
            return flowResponse;
        }
        catch (InvalidateFlowException ex) {
            this.invalidateFlow(ex);
            throw ex;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    @Override
    public void action(String flowToken, String action, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        LOGGER.debug("start action[{}] processing, flow token [{}], form data [{}]", new Object[]{action, flowToken, formData});
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        FlowFormTemplate currentFormTemplate = this.getCurrentFormTemplate(flowData);
        if (StringUtils.isBlank((CharSequence)action)) {
            LOGGER.warn("null action can't process, flow token [{}], form [{}]", (Object)flowToken, (Object)currentFormTemplate.getName());
            httpResponse.setStatus(404);
            return;
        }
        try {
            if (!this.processAction(flowToken, action, flowData, formData, currentFormTemplate, httpRequest, httpResponse)) {
                LOGGER.warn("no processor exist to handle action [{}], flow token [{}], form [{}]", new Object[]{action, flowToken, currentFormTemplate.getName()});
                throw new InvalidateFlowException(flowToken, "invalid action");
            }
        }
        catch (InvalidateFlowException ex) {
            this.invalidateFlow(ex);
            throw ex;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    @Override
    public FlowResponse<String> getCurrent(String flowToken, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        if (flowData.getNextStepIndex() == 1) {
            flowData.setLocale(locale);
            this.updateFlowData(flowToken, flowData);
        }
        FlowFormTemplate currentFormTemplate = this.getCurrentFormTemplate(flowData);
        return this.toResponse(currentFormTemplate, flowData, null, httpRequest);
    }

    protected boolean processAction(String flowToken, String action, D flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        for (FlowInputFieldTemplate fieldTemplate : currentFormTemplate.getFieldTemplates(((FlowData)flowData).getData(), FlowInputFieldTemplate.class)) {
            if (!this.process(fieldTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) continue;
            return true;
        }
        if (this.process(currentFormTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) {
            return true;
        }
        return this.process(this.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse);
    }

    protected void fillFlowData(Map<String, String> flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate, Locale locale, HttpServletRequest httpRequest) throws Exception {
        currentFormTemplate.validate(flowData, formData, locale, httpRequest);
        for (InputFieldTemplate inputFieldTemplate : currentFormTemplate.getFieldTemplates(flowData, InputFieldTemplate.class)) {
            String value;
            if (!inputFieldTemplate.isPersistentValue() || !StringUtils.isNotBlank((CharSequence)(value = formData.remove(inputFieldTemplate.getName())))) continue;
            flowData.put(inputFieldTemplate.getName(), WebUtils.escapeString((String)value));
        }
    }

    protected FlowResponse<String> processNextForm(String flowToken, D flowData, Map<String, String> formData, String responseData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse<String> response;
        FlowFormTemplate nextFormTemplate = this.getNextFormTemplate(flowData);
        if (null != nextFormTemplate) {
            this.process(nextFormTemplate.getPreProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
        }
        if (Boolean.TRUE.equals((response = this.toResponse(nextFormTemplate, flowData, responseData, httpRequest)).getFinished())) {
            this.onFinished(flowToken, flowData, formData, httpRequest, httpResponse);
        }
        return response;
    }

    protected FlowFormTemplate getNextFormTemplate(D flowData) throws Exception {
        if (this.getForms((FlowData)flowData).size() <= ((FlowData)flowData).getNextStepIndex()) {
            return null;
        }
        return this.getForms((FlowData)flowData).get(((FlowData)flowData).getNextStepIndex());
    }

    protected FlowFormTemplate getCurrentFormTemplate(D flowData) throws Exception {
        return this.getForms((FlowData)flowData).get(((FlowData)flowData).getNextStepIndex() - 1);
    }

    protected void onFinished(String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.process(this.getPostProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
        this.cleanFlowData(flowToken);
    }

    protected void updateFlowData(String flowToken, D flowData) {
        if (this.getFlowDataRepository().contains(flowToken)) {
            this.getFlowDataRepository().put(flowToken, flowData);
        }
    }

    protected void invalidateFlow(InvalidateFlowException ex) {
        this.cleanFlowData(ex.getFlowToken());
    }

    protected FlowResponse<String> toResponse(FlowFormTemplate formTemplate, D flowData, String responseData, HttpServletRequest httpRequest) throws Exception {
        FlowResponse response = new FlowResponse((Object)responseData);
        if (null != formTemplate) {
            BardForm nextForm = FormUtils.toForm((FormTemplate)formTemplate, ((FlowData)flowData).getData(), ((FlowData)flowData).getData(), (Locale)((FlowData)flowData).getLocale(), (HttpServletRequest)httpRequest);
            response.setForm(nextForm);
            response.setSteps(this.getStepsCounts((FlowData)flowData));
            response.setCurrent(((FlowData)flowData).getNextStepIndex());
        }
        if (null == formTemplate || formTemplate.isFinished()) {
            response.setFinished(Boolean.TRUE);
        }
        return response;
    }

    protected int getStepsCounts(FlowData flowData) {
        return this.getForms(flowData).size();
    }

    protected void cleanFlowData(String flowToken) {
        this.getFlowDataRepository().remove(flowToken);
    }

    protected boolean process(List<FormProcessor> processors, String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (CollectionUtils.isEmpty(processors)) {
            return false;
        }
        List executableProcessors = processors.stream().filter(formProcessor -> formProcessor.mustExecute(flowData.getData())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(executableProcessors)) {
            return false;
        }
        for (FormProcessor processor : executableProcessors) {
            processor.process(flowToken, ((FlowData)flowData).getData(), formData, ((FlowData)flowData).getLocale(), httpRequest, httpResponse);
        }
        return true;
    }

    protected boolean isStarted(String flowToken) throws InvalidateFlowException {
        FlowData flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
        return null != flowData && flowData.getNextStepIndex() > 0;
    }

    public FlowDataRepository<D> getFlowDataRepository() {
        return this.flowDataRepository;
    }

    public List<FlowFormTemplate> getForms(FlowData flowData) {
        return this.forms.stream().filter(formTemplate -> formTemplate.mustShow(flowData.getData())).collect(Collectors.toList());
    }

    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }

    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }
}

