/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.bardframework.flow.FlowData;
import org.bardframework.flow.FlowHandlerAbstract;

public class FlowHandlerChain
extends FlowHandlerAbstract<FlowData> {
    private final List<FlowHandlerAbstract<FlowData>> flowHandlers;
    private final PreProcessorExecutionStrategy preProcessorExecutionStrategy;
    private final PostProcessorExecutionStrategy postProcessorExecutionStrategy;

    public FlowHandlerChain(List<FlowHandlerAbstract<FlowData>> flowHandlers) {
        this(flowHandlers, PreProcessorExecutionStrategy.EXECUTE_FIRST, PostProcessorExecutionStrategy.EXECUTE_LAST);
    }

    public FlowHandlerChain(List<FlowHandlerAbstract<FlowData>> flowHandlers, PreProcessorExecutionStrategy preProcessorExecutionStrategy, PostProcessorExecutionStrategy postProcessorExecutionStrategy) {
        super(flowHandlers.get(0).getFlowDataRepository(), flowHandlers.stream().map(handler -> handler.forms).flatMap(Collection::stream).collect(Collectors.toList()));
        this.flowHandlers = flowHandlers;
        this.preProcessorExecutionStrategy = preProcessorExecutionStrategy;
        this.postProcessorExecutionStrategy = postProcessorExecutionStrategy;
        this.getFlowHandlers().stream().map(FlowHandlerAbstract::getActionProcessors).forEach(this.actionProcessors::putAll);
    }

    @PostConstruct
    void init() {
        if (this.getPreProcessorExecutionStrategy() == PreProcessorExecutionStrategy.EXECUTE_FIRST) {
            this.preProcessors.addAll(this.getFlowHandlers().get(0).getPreProcessors());
        } else if (this.getPreProcessorExecutionStrategy() == PreProcessorExecutionStrategy.EXECUTE_ALL) {
            this.preProcessors.addAll(this.getFlowHandlers().stream().map(FlowHandlerAbstract::getPreProcessors).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        if (this.getPostProcessorExecutionStrategy() == PostProcessorExecutionStrategy.EXECUTE_LAST) {
            this.postProcessors.addAll(0, this.getFlowHandlers().get(this.getFlowHandlers().size() - 1).getPostProcessors());
        } else if (this.getPostProcessorExecutionStrategy() == PostProcessorExecutionStrategy.EXECUTE_ALL) {
            this.postProcessors.addAll(0, this.getFlowHandlers().stream().map(FlowHandlerAbstract::getPostProcessors).flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    public PreProcessorExecutionStrategy getPreProcessorExecutionStrategy() {
        return this.preProcessorExecutionStrategy;
    }

    public PostProcessorExecutionStrategy getPostProcessorExecutionStrategy() {
        return this.postProcessorExecutionStrategy;
    }

    public List<FlowHandlerAbstract<FlowData>> getFlowHandlers() {
        return this.flowHandlers;
    }

    protected static enum PostProcessorExecutionStrategy {
        EXECUTE_NONE,
        EXECUTE_LAST,
        EXECUTE_ALL;

    }

    protected static enum PreProcessorExecutionStrategy {
        EXECUTE_NONE,
        EXECUTE_FIRST,
        EXECUTE_ALL;

    }
}

