/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.flow.form.field.input.FlowInputFieldTemplate;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.field.FieldTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class FlowFormTemplate
extends FormTemplate {
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<FormProcessor> preProcessors;
    private List<FormProcessor> postProcessors;
    private Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();
    private boolean finished;

    public FlowFormTemplate(String name, List<FieldTemplate<?>> fieldTemplates, MessageSource messageSource) {
        super(name, fieldTemplates, messageSource);
    }

    @PostConstruct
    protected void configurationValidate() {
        if (CollectionUtils.isNotEmpty(this.postProcessors)) {
            if (this.finished) {
                throw new IllegalStateException("when finished is true, can't set postProcessors");
            }
            this.postProcessors.forEach(processor -> processor.configurationValidate(this));
        }
        if (CollectionUtils.isNotEmpty(this.preProcessors)) {
            this.preProcessors.forEach(processor -> processor.configurationValidate(this));
        }
        ArrayList inputFieldTemplates = new ArrayList();
        this.fieldTemplates.stream().filter(fieldTemplate -> fieldTemplate instanceof FlowInputFieldTemplate).forEach(fieldTemplate -> inputFieldTemplates.add((FlowInputFieldTemplate)((Object)fieldTemplate)));
        ArrayList<FormProcessor> processors = new ArrayList<FormProcessor>();
        for (FlowInputFieldTemplate inputFieldTemplate : inputFieldTemplates) {
            if (null == inputFieldTemplate.getPreProcessors()) continue;
            processors.addAll(inputFieldTemplate.getPreProcessors());
        }
        if (null != this.preProcessors) {
            processors.addAll(this.preProcessors);
        }
        processors.sort(FormProcessor::compareTo);
        this.preProcessors = processors;
        processors = new ArrayList();
        for (FlowInputFieldTemplate inputFieldTemplate : inputFieldTemplates) {
            if (null == inputFieldTemplate.getPostProcessors()) continue;
            processors.addAll(inputFieldTemplate.getPostProcessors());
        }
        if (null != this.postProcessors) {
            processors.addAll(this.postProcessors);
        }
        processors.sort(FormProcessor::compareTo);
        this.postProcessors = processors;
    }

    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }

    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }
}

