/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.captcha;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.bardframework.commons.captcha.GeneratedCaptcha;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.form.field.input.captcha.CaptchaGenerator;
import org.bardframework.flow.processor.FormProcessorAbstract;

public class CaptchaGeneratorProcessor
extends FormProcessorAbstract {
    private final CaptchaGenerator captchaGenerator;
    private final int maxCaptchaGenerateCount;

    public CaptchaGeneratorProcessor(CaptchaGenerator captchaGenerator, int maxCaptchaGenerateCount) {
        this.captchaGenerator = captchaGenerator;
        this.maxCaptchaGenerateCount = maxCaptchaGenerateCount;
    }

    @Override
    public void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        int captchaGenerateCount;
        int n = captchaGenerateCount = flowData.containsKey("S_captcha_generate_count") ? Integer.parseInt(flowData.get("S_captcha_generate_count")) : 0;
        if (captchaGenerateCount > this.maxCaptchaGenerateCount) {
            throw new InvalidateFlowException(flowToken, "max captcha generation exceed");
        }
        GeneratedCaptcha captcha = this.captchaGenerator.generate();
        flowData.put("S_captcha_generate_count", String.valueOf(captchaGenerateCount + 1));
        flowData.put("S_captcha_answer", captcha.getValue());
        IOUtils.write((String)("data:image/png;base64," + Base64.getEncoder().encodeToString(captcha.getImage())), (OutputStream)httpResponse.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        httpResponse.setHeader("Content-Type", "image/png");
        httpResponse.setStatus(200);
    }
}

