/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.captcha;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.flow.exception.FlowDataValidationException;
import org.bardframework.flow.form.field.input.captcha.CaptchaFieldTemplate;
import org.bardframework.flow.processor.FormProcessorAbstract;

public class CaptchaValidatorProcessor
extends FormProcessorAbstract {
    private final CaptchaFieldTemplate captchaFieldTemplate;

    public CaptchaValidatorProcessor(CaptchaFieldTemplate captchaFieldTemplate) {
        this.captchaFieldTemplate = captchaFieldTemplate;
    }

    @Override
    public void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String captchaFieldName = this.captchaFieldTemplate.getName();
        String enteredCaptcha = formData.get(captchaFieldName);
        if (StringUtils.isBlank((CharSequence)enteredCaptcha)) {
            this.LOGGER.debug("entered captcha is empty, flow token: [{}]", (Object)flowToken);
            throw new FlowDataValidationException().addFiledError(captchaFieldName);
        }
        String captchaAnswer = flowData.get("S_captcha_answer");
        if (StringUtils.isBlank((CharSequence)captchaAnswer)) {
            this.LOGGER.debug("saved captcha answer in server is blank, flow token: [{}]", (Object)flowToken);
            throw new FlowDataValidationException().addFiledError(captchaFieldName);
        }
        flowData.remove("S_captcha_answer");
        if (!captchaAnswer.equalsIgnoreCase(enteredCaptcha.replaceAll(" ", ""))) {
            throw new FlowDataValidationException().addFiledError(captchaFieldName);
        }
        flowData.remove("S_captcha_generate_count");
    }

    @Override
    public int order() {
        return -100;
    }
}

