/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.otpsms;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.flow.exception.FlowDataValidationException;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.form.field.input.otpsms.OtpSmsValidatorFieldTemplate;
import org.bardframework.flow.processor.FormProcessorAbstract;

public class OtpValidatorProcessor
extends FormProcessorAbstract {
    private final OtpSmsValidatorFieldTemplate fieldTemplate;
    private final int maxTryToResolveCount;

    public OtpValidatorProcessor(OtpSmsValidatorFieldTemplate fieldTemplate, int maxTryToResolveCount) {
        this.fieldTemplate = fieldTemplate;
        this.maxTryToResolveCount = maxTryToResolveCount;
    }

    @Override
    public void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        int smsResolveTryCount;
        String enteredOtp = formData.get(this.fieldTemplate.getName());
        String generatedOtp = flowData.get("X_G_OTP");
        if (StringUtils.isBlank((CharSequence)generatedOtp)) {
            throw new InvalidateFlowException(flowToken, "generated otp is empty, can't validate otp.");
        }
        if (generatedOtp.equalsIgnoreCase(enteredOtp.trim())) {
            flowData.remove("X_G_OTP");
            flowData.remove("S_otp_resolve_count");
            return;
        }
        int n = smsResolveTryCount = flowData.containsKey("S_otp_resolve_count") ? Integer.parseInt(flowData.get("S_otp_resolve_count")) : 0;
        if (smsResolveTryCount >= this.maxTryToResolveCount) {
            throw new InvalidateFlowException(flowToken, "too many try to resolve sms, terminating flow...");
        }
        flowData.put("S_otp_resolve_count", String.valueOf(smsResolveTryCount + 1));
        throw new FlowDataValidationException().addFiledError(this.fieldTemplate.getName());
    }
}

