/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.otpsms;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.flow.form.field.input.otpsms.OtpSmsSenderProcessor;
import org.bardframework.flow.processor.FormProcessorAbstract;
import org.springframework.http.HttpStatus;

public class ResendOtpProcessor
extends FormProcessorAbstract {
    private final OtpSmsSenderProcessor otpSmsSenderProcessor;
    private final int maxResendOtpCount;
    private final int resendIntervalSeconds;

    public ResendOtpProcessor(OtpSmsSenderProcessor otpSmsSenderProcessor, int maxResendOtpCount, int resendIntervalSeconds) {
        this.otpSmsSenderProcessor = otpSmsSenderProcessor;
        this.maxResendOtpCount = maxResendOtpCount;
        this.resendIntervalSeconds = resendIntervalSeconds;
    }

    @Override
    public void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        int resendCount;
        int n = resendCount = flowData.containsKey("S_otp_resend_count") ? Integer.parseInt(flowData.get("S_otp_resend_count")) : 0;
        if (resendCount > this.maxResendOtpCount) {
            httpResponse.setStatus(HttpStatus.UNAVAILABLE_FOR_LEGAL_REASONS.value());
            this.LOGGER.error("flowToken[{}], max otp resend exceed", (Object)flowToken);
            return;
        }
        long sentTime = flowData.containsKey("S_otp_sent_time") ? Long.parseLong(flowData.get("S_otp_sent_time")) : 0L;
        long remainSeconds = (long)this.resendIntervalSeconds - (System.currentTimeMillis() - sentTime) / 1000L;
        if (remainSeconds > 0L) {
            this.LOGGER.error("flowToken[{}], try to resend otp, before resend interval!", (Object)flowToken);
            httpResponse.getWriter().println(remainSeconds);
            httpResponse.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            return;
        }
        this.otpSmsSenderProcessor.process(flowToken, flowData, formData, locale, httpRequest, httpResponse);
    }
}

