/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.processor.dataprovider;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.web.utils.ResourceUtils;
import org.bardframework.commons.web.utils.WebUtils;
import org.bardframework.flow.exception.FlowExecutionException;
import org.bardframework.flow.processor.FormProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProviderCsvFileProcessor
extends FormProcessorAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProviderCsvFileProcessor.class);
    protected final String csvFileLocation;
    protected final Map<Integer, String> mapper;
    protected final String identifierFieldName;
    protected final String errorMessageCode;
    protected String separator = ",";

    public DataProviderCsvFileProcessor(String csvFileLocation, String identifierFieldName, Map<Integer, String> mapper, String errorMessageCode) {
        this.csvFileLocation = csvFileLocation;
        this.identifierFieldName = identifierFieldName;
        this.errorMessageCode = errorMessageCode;
        this.mapper = mapper;
    }

    @Override
    public void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String identifier = flowData.get(this.getIdentifierFieldName());
        if (StringUtils.isBlank((CharSequence)identifier)) {
            LOGGER.warn("identifier not exist for [{}], can't read data from csv file", flowData);
            throw new FlowExecutionException(List.of("execution_error"));
        }
        try (InputStream inputStream = ResourceUtils.getResource((String)this.getCsvFileLocation()).getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            do {
                String[] parts;
                if (null == (line = reader.readLine()) || !(parts = new String(line.getBytes(), StandardCharsets.UTF_8).split(this.getSeparator()))[0].trim().equalsIgnoreCase(identifier)) continue;
                for (Integer index : this.mapper.keySet()) {
                    if (index >= parts.length) {
                        LOGGER.warn("can't find attribute[{}] value for[{}]", (Object)this.mapper.get(index), (Object)identifier);
                        continue;
                    }
                    flowData.put(this.mapper.get(index), WebUtils.escapeString((String)parts[index]));
                }
                return;
            } while (line != null);
        }
        LOGGER.warn("can't find record for[{}] in csv file [{}]", (Object)identifier, (Object)this.getCsvFileLocation());
        throw new FlowExecutionException(List.of(this.errorMessageCode));
    }

    public String getCsvFileLocation() {
        return this.csvFileLocation;
    }

    public Map<Integer, String> getMapper() {
        return this.mapper;
    }

    public String getIdentifierFieldName() {
        return this.identifierFieldName;
    }

    public String getErrorMessageCode() {
        return this.errorMessageCode;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

