/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.processor.messagesender;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.flow.exception.FlowExecutionException;
import org.bardframework.flow.processor.FormProcessorAbstract;
import org.bardframework.flow.processor.messagesender.creator.MessageCreator;
import org.bardframework.flow.processor.messagesender.sender.MessageSender;
import org.bardframework.time.LocalDateTimeJalali;

public class MessageSenderProcessor
extends FormProcessorAbstract {
    protected final MessageCreator messageCreator;
    protected final MessageSender messageSender;
    protected final String errorMessageCode;
    protected final Executor executor = Executors.newFixedThreadPool(100);
    protected boolean failOnError = true;
    protected boolean executeInNewThread = false;
    protected DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    protected DateTimeFormatter dateFormatterJalali = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    protected DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("H:mm:ss");

    public MessageSenderProcessor(MessageCreator messageCreator, MessageSender messageSender, String errorMessageCode) {
        this.messageCreator = messageCreator;
        this.messageSender = messageSender;
        this.errorMessageCode = errorMessageCode;
    }

    @Override
    public final void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String message = this.getMessageCreator().create(flowData, locale);
        this.LOGGER.debug("sending message [{}]", (Object)message);
        if (this.isExecuteInNewThread()) {
            this.getExecutor().execute(() -> this.sendInternal(message, flowData, locale));
        } else {
            this.sendInternal(message, flowData, locale);
        }
    }

    private void sendInternal(String message, Map<String, String> flowData, Locale locale) {
        try {
            this.beforeSend(flowData);
            this.getMessageSender().send(message, this.getArgs(flowData), locale);
            this.afterSend(flowData);
        }
        catch (Exception e) {
            this.LOGGER.error("error sending message, catching exception.", (Throwable)e);
            if (!this.isFailOnError()) {
                return;
            }
            throw new FlowExecutionException(List.of(this.errorMessageCode));
        }
    }

    protected Map<String, String> getArgs(Map<String, String> flowData) {
        HashMap<String, String> args = new HashMap<String, String>(flowData);
        LocalDateTimeJalali dateTimeJalali = LocalDateTimeJalali.now();
        LocalDateTime dateTime = LocalDateTime.now();
        args.put("date", dateTime.format(this.getDateFormat()));
        args.put("jalali_date", dateTimeJalali.format(this.getDateFormatterJalali()));
        args.put("time", dateTime.format(this.getTimeFormat()));
        return args;
    }

    protected void beforeSend(Map<String, String> flowData) {
    }

    protected void afterSend(Map<String, String> flowData) {
    }

    public MessageCreator getMessageCreator() {
        return this.messageCreator;
    }

    public MessageSender getMessageSender() {
        return this.messageSender;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getErrorMessageCode() {
        return this.errorMessageCode;
    }

    public DateTimeFormatter getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateTimeFormatter getDateFormatterJalali() {
        return this.dateFormatterJalali;
    }

    public void setDateFormatterJalali(DateTimeFormatter dateFormatterJalali) {
        this.dateFormatterJalali = dateFormatterJalali;
    }

    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateTimeFormatter timeFormat) {
        this.timeFormat = timeFormat;
    }

    public boolean isExecuteInNewThread() {
        return this.executeInNewThread;
    }

    public void setExecuteInNewThread(boolean executeInNewThread) {
        this.executeInNewThread = executeInNewThread;
    }
}

