/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.processor.messagesender.sender;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.flow.processor.messagesender.creator.MessageCreator;
import org.bardframework.flow.processor.messagesender.sender.MessageSender;
import org.bardframework.form.field.FieldTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSenderEmail
implements MessageSender {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MessageSenderEmail.class);
    private final InternetAddress senderEmail;
    private final Properties configs;
    private final MessageCreator subjectCreator;
    private final FieldTemplate<?> receiverEmailFieldTemplate;
    private final Authenticator authenticator;

    public MessageSenderEmail(String senderEmail, final String senderUsername, final String senderPassword, Properties configs, MessageCreator subjectCreator, FieldTemplate<?> receiverEmailFieldTemplate) throws AddressException {
        this.senderEmail = InternetAddress.parse((String)senderEmail)[0];
        this.configs = configs;
        this.subjectCreator = subjectCreator;
        this.receiverEmailFieldTemplate = receiverEmailFieldTemplate;
        this.authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(senderUsername, senderPassword);
            }
        };
    }

    @Override
    public void send(String message, Map<String, String> args, Locale locale) throws Exception {
        String receiverEmail = args.get(this.getReceiverEmailFieldTemplate().getName());
        if (StringUtils.isBlank((CharSequence)receiverEmail)) {
            LOGGER.warn("receiver email not exist for [{}], can't send email", args);
            throw new IllegalStateException("receiver email not exist in args");
        }
        Session session = Session.getInstance((Properties)this.configs, (Authenticator)this.authenticator);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)this.senderEmail);
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)receiverEmail));
        mimeMessage.setSubject(this.subjectCreator.create(args, locale));
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)message, "text/html; charset=utf-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMessage.setContent((Multipart)multipart);
        Transport.send((Message)mimeMessage);
    }

    public FieldTemplate<?> getReceiverEmailFieldTemplate() {
        return this.receiverEmailFieldTemplate;
    }
}

