/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.repository;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.repository.FlowDataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowDataRepositoryInMemory<D>
implements FlowDataRepository<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowDataRepositoryInMemory.class);
    private final Cache<String, D> cache;

    public FlowDataRepositoryInMemory(long expirationMs) {
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(expirationMs, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public boolean contains(String token) {
        return this.cache.getIfPresent((Object)token) != null;
    }

    @Override
    public void put(String token, D data) {
        this.cache.put((Object)token, data);
    }

    @Override
    public D get(String token) throws InvalidateFlowException {
        Object data = this.cache.getIfPresent((Object)token);
        if (null == data) {
            throw new InvalidateFlowException(token, "no data exist for token");
        }
        return (D)data;
    }

    @Override
    public void remove(String token) {
        this.cache.invalidate((Object)token);
    }
}

