/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.phonenumber;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.flow.form.field.input.phonenumber.PhoneNumber;
import org.bardframework.flow.form.field.input.phonenumber.PhoneNumberField;
import org.bardframework.flow.form.field.input.phonenumber.PhoneNumberParser;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.FormUtils;
import org.bardframework.form.exception.FormDataValidationException;
import org.bardframework.form.field.input.CountrySelectField;
import org.bardframework.form.field.input.CountrySelectFieldTemplate;
import org.bardframework.form.field.input.InputField;
import org.bardframework.form.field.input.InputFieldTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneNumberFieldTemplate
extends InputFieldTemplate<PhoneNumberField, String> {
    private static final Logger log = LoggerFactory.getLogger(PhoneNumberFieldTemplate.class);
    private final PhoneNumberParser phoneNumberParser;
    private final CountrySelectFieldTemplate countrySelectFieldTemplate;

    protected PhoneNumberFieldTemplate(String name, PhoneNumberParser phoneNumberParser, CountrySelectFieldTemplate countrySelectFieldTemplate) {
        super(name);
        this.phoneNumberParser = phoneNumberParser;
        this.countrySelectFieldTemplate = countrySelectFieldTemplate;
    }

    public void validate(String flowToken, FormTemplate formTemplate, Map<String, String> flowData, Map<String, String> formData, Locale locale, FormDataValidationException ex) throws Exception {
        PhoneNumberField formField = (PhoneNumberField)this.toField(formTemplate, formData, locale);
        if (Boolean.TRUE.equals(formField.getDisable())) {
            return;
        }
        String fieldName = this.getName();
        String stringValue = formData.get(fieldName);
        try {
            String phoneNumberString;
            String value = this.toValue(stringValue);
            if (!this.isValid(flowToken, formField, value, formData)) {
                ex.addFieldError(fieldName, formField.getErrorMessage());
            }
            if (null == (phoneNumberString = formData.get(fieldName))) {
                ex.addFieldError(fieldName, formField.getErrorMessage());
            }
            PhoneNumber phoneNumber = this.phoneNumberParser.parse(phoneNumberString);
            formData.put(this.countrySelectFieldTemplate.getName(), phoneNumber.getCountryAlphaCode());
            this.countrySelectFieldTemplate.validate(flowToken, formTemplate, flowData, formData, locale, ex);
        }
        catch (Exception e) {
            log.error("Unknown error: {} in validation field {}", (Object)e.getMessage(), (Object)fieldName);
            ex.addFieldError(fieldName, formField.getErrorMessage());
        }
    }

    public boolean isValid(String flowToken, PhoneNumberField field, String value, Map<String, String> flowData) {
        if (null == value) {
            if (Boolean.TRUE.equals(field.getRequired())) {
                log.debug("field [{}] is required, but it's value is empty", (Object)field.getName());
                return false;
            }
            return true;
        }
        PhoneNumber phoneNumber = this.phoneNumberParser.parse(value);
        if (null != field.getMaxLength() && phoneNumber.getFullNumber().length() > field.getMaxLength()) {
            log.debug("field [{}] max length is [{}], but it's value[{}] length is greater than maximum", new Object[]{field.getName(), field.getMaxLength(), phoneNumber});
            return false;
        }
        return true;
    }

    public void fill(FormTemplate formTemplate, PhoneNumberField field, Map<String, String> args, Locale locale) throws Exception {
        super.fill(formTemplate, (InputField)field, args, locale);
        field.setMaxLength(FormUtils.getFieldIntegerProperty((FormTemplate)formTemplate, (String)this.getName(), (String)"maxLength", (Locale)locale, args, (Integer)((PhoneNumberField)this.getDefaultValues()).getMaxLength()));
        CountrySelectField countrySelectField = new CountrySelectField();
        this.countrySelectFieldTemplate.fill(formTemplate, countrySelectField, args, locale);
        field.setCountrySelectField(countrySelectField);
    }

    public String toValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return this.phoneNumberParser.parse(value).getFullNumber();
    }
}

