/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.field.FieldTemplate;
import org.springframework.context.MessageSource;

public class FlowFormTemplate
extends FormTemplate {
    private List<FormProcessor> preProcessors = new ArrayList<FormProcessor>();
    private List<FormProcessor> postProcessors = new ArrayList<FormProcessor>();
    private Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();
    private boolean finished;

    public FlowFormTemplate(String name, List<FieldTemplate<?>> fieldTemplates, MessageSource messageSource) {
        super(name, fieldTemplates, messageSource);
    }

    @PostConstruct
    protected void configurationValidate() {
        if (CollectionUtils.isNotEmpty(this.getPostProcessors()) && this.isFinished()) {
            throw new IllegalStateException("when finished is true, can't set postProcessors");
        }
        this.getPreProcessors().forEach(processor -> processor.configurationValidate(this));
        this.getPostProcessors().forEach(processor -> processor.configurationValidate(this));
    }

    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }

    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }
}

