/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.otp.time;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.bardframework.commons.utils.StringTemplateUtils;
import org.bardframework.flow.form.field.input.otp.time.OtpServiceAbstract;

public class TotpService
extends OtpServiceAbstract {
    private static final String KEY_URI_TEMPLATE = "otpauth://totp/::label::?secret=::secret::&issuer=::issuer::&algorithm=::algorithm::&digits=::length::&period=::periodSeconds::";
    private int periodSeconds = 30;
    private int window = 5;

    public String getUri(String issuer, String label, String secretBase32) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("algorithm", this.getAlgorithm());
        args.put("length", String.valueOf(this.getLength()));
        args.put("periodSeconds", String.valueOf(this.getPeriodSeconds()));
        args.put("label", label);
        args.put("issuer", issuer);
        args.put("secret", secretBase32);
        return StringTemplateUtils.fillTemplate((String)KEY_URI_TEMPLATE, args);
    }

    @Override
    public String generate(byte[] secret) {
        return null;
    }

    private long generateTOTP(long time, byte[] secret) throws GeneralSecurityException {
        byte[] data = new byte[8];
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)time;
            time >>>= 8;
        }
        byte[] result = this.hmac(data, secret);
        int offset = result[result.length - 1] & 0xF;
        long truncatedResult = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedResult = truncatedResult << 8 | (long)(result[offset + i2] & 0xFF);
        }
        return (truncatedResult & Integer.MAX_VALUE) % (long)Math.pow(10.0, this.getLength());
    }

    private long generateTOTP2(long time, byte[] key) throws GeneralSecurityException {
        StringBuilder timeBuilder = new StringBuilder(String.valueOf(time));
        while (timeBuilder.length() < 16) {
            timeBuilder.insert(0, "0");
        }
        byte[] msg = ArrayUtils.remove((byte[])new BigInteger("10" + String.valueOf(timeBuilder), 16).toByteArray(), (int)0);
        byte[] hash = this.hmac(msg, key);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        return (long)binary % (long)Math.pow(10.0, this.getLength());
    }

    @Override
    public boolean verify(String otp, byte[] secret) throws GeneralSecurityException {
        if (!NumberUtils.isDigits((String)otp)) {
            return false;
        }
        int code = Integer.parseInt(otp);
        long timeSeconds = System.currentTimeMillis() / 30000L;
        for (int i = -this.getWindow(); i <= this.getWindow(); ++i) {
            long generatedOtp = this.generateTOTP(timeSeconds + (long)i, secret);
            if (generatedOtp != (long)code) continue;
            return true;
        }
        return false;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        if (window < 1 || window > 10) {
            throw new IllegalStateException("Window size provided not allowed: " + window);
        }
        this.window = window;
    }

    public int getPeriodSeconds() {
        return this.periodSeconds;
    }

    public void setPeriodSeconds(int periodSeconds) {
        this.periodSeconds = periodSeconds;
    }
}

