/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.commons.web.utils.WebUtils;
import org.bardframework.flow.FlowData;
import org.bardframework.flow.FlowHandler;
import org.bardframework.flow.FlowResponse;
import org.bardframework.flow.exception.FlowDataValidationException;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.form.FlowFormTemplate;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.flow.form.field.input.FlowInputFieldTemplate;
import org.bardframework.flow.repository.FlowDataRepository;
import org.bardframework.form.BardForm;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.FormUtils;
import org.bardframework.form.field.input.InputFieldTemplateAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowHandlerAbstract<D extends FlowData>
implements FlowHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final FlowDataRepository<D> flowDataRepository;
    protected final List<FlowFormTemplate> forms;
    protected List<FormProcessor> preProcessors = new ArrayList<FormProcessor>();
    protected List<FormProcessor> postProcessors = new ArrayList<FormProcessor>();
    protected Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();

    public FlowHandlerAbstract(FlowDataRepository<D> flowDataRepository, List<FlowFormTemplate> forms) {
        this.flowDataRepository = flowDataRepository;
        this.forms = forms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse start(Map<String, String> initValues, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)ReflectionUtils.newInstance((Class)ReflectionUtils.getGenericArgType(this.getClass(), (int)0));
        String flowToken = this.generateFlowToken();
        flowData.setLocale(locale);
        flowData.getData().putAll(initValues);
        flowData.setCurrentFormIndex(-1);
        this.getFlowDataRepository().put(flowToken, flowData);
        FlowFormTemplate currentFormTemplate = null;
        try {
            this.process(this.getPreProcessors(flowData), flowToken, flowData, Map.of(), httpRequest, httpResponse);
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
            FlowResponse flowResponse = this.processNextForm(flowToken, flowData, Map.of(), httpRequest, httpResponse);
            return flowResponse;
        }
        catch (Exception e) {
            FlowResponse flowResponse = this.handleExceptionInternal(flowToken, flowData, initValues, currentFormTemplate, FlowAction.START, e);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse submit(String flowToken, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = null;
        FlowFormTemplate currentFormTemplate = null;
        try {
            flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
        }
        catch (Exception ex) {
            return this.handleExceptionInternal(flowToken, flowData, formData, currentFormTemplate, FlowAction.SUBMIT_FORM, ex);
        }
        try {
            if (!Objects.equals(locale, flowData.getLocale())) {
                this.onLocaleChange(flowToken, flowData, formData, FlowAction.SUBMIT_FORM, flowData.getLocale(), locale, httpRequest, httpResponse);
            }
            currentFormTemplate.validate(flowToken, flowData.getData(), formData, flowData.getLocale());
            this.fillFlowData(flowData.getData(), formData, currentFormTemplate);
            this.process(currentFormTemplate.getPostProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            FlowResponse ex = this.processNextForm(flowToken, flowData, formData, httpRequest, httpResponse);
            return ex;
        }
        catch (Exception ex) {
            FlowResponse flowResponse = this.handleExceptionInternal(flowToken, flowData, formData, currentFormTemplate, FlowAction.SUBMIT_FORM, ex);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object action(String flowToken, String action, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.log.debug("start action[{}] processing, flow token [{}], form data [{}]", new Object[]{action, flowToken, formData});
        FlowData flowData = null;
        FlowFormTemplate currentFormTemplate = null;
        try {
            flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
            if (StringUtils.isBlank((CharSequence)action)) {
                this.log.warn("null action can't process, flow token [{}], form [{}]", (Object)flowToken, (Object)currentFormTemplate.getName());
                httpResponse.setStatus(404);
                Object var9_9 = null;
                return var9_9;
            }
            if (!Objects.equals(locale, flowData.getLocale())) {
                this.onLocaleChange(flowToken, flowData, formData, FlowAction.PROCESS_ACTION, flowData.getLocale(), locale, httpRequest, httpResponse);
            }
            if (!this.processAction(flowToken, action, flowData, formData, currentFormTemplate, httpRequest, httpResponse)) {
                this.log.warn("no processor exist to handle action [{}], flow token [{}], form [{}]", new Object[]{action, flowToken, currentFormTemplate.getName()});
                throw new InvalidateFlowException(flowToken, "invalid action", null);
            }
        }
        catch (Exception ex) {
            FlowResponse flowResponse = this.handleExceptionInternal(flowToken, flowData, formData, currentFormTemplate, FlowAction.PROCESS_ACTION, ex);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
        return null;
    }

    @Override
    public FlowResponse getCurrent(String flowToken, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = null;
        FlowFormTemplate currentFormTemplate = null;
        try {
            flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
            if (flowData.getCurrentFormIndex() == 0) {
                flowData.setLocale(locale);
                this.updateFlowData(flowToken, flowData);
            }
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
            if (!Objects.equals(locale, flowData.getLocale())) {
                this.onLocaleChange(flowToken, flowData, Map.of(), FlowAction.GET_CURRENT, flowData.getLocale(), locale, httpRequest, httpResponse);
            }
            return this.toResponse(flowToken, currentFormTemplate, flowData, httpRequest, httpResponse);
        }
        catch (Exception ex) {
            return this.handleExceptionInternal(flowToken, flowData, Map.of(), currentFormTemplate, FlowAction.GET_CURRENT, ex);
        }
    }

    protected boolean processAction(String flowToken, String action, D flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        for (FlowInputFieldTemplate fieldTemplate : currentFormTemplate.getFieldTemplates(((FlowData)flowData).getData(), formData, FlowInputFieldTemplate.class)) {
            if (!this.process(fieldTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) continue;
            return true;
        }
        if (this.process(currentFormTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) {
            return true;
        }
        return this.process(this.getActionProcessors(flowData).get(action), flowToken, flowData, formData, httpRequest, httpResponse);
    }

    protected void fillFlowData(Map<String, String> flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate) {
        for (InputFieldTemplateAbstract inputFieldTemplate : currentFormTemplate.getFieldTemplates(flowData, formData, InputFieldTemplateAbstract.class)) {
            if (!inputFieldTemplate.isPersistentValue()) continue;
            String value = formData.remove(inputFieldTemplate.getName());
            if (!Boolean.TRUE.equals(currentFormTemplate.getSubmitEmptyInputs()) && !StringUtils.isNotBlank((CharSequence)value)) continue;
            flowData.put(inputFieldTemplate.getName(), WebUtils.escapeString((String)value));
        }
    }

    protected FlowResponse processNextForm(String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse response;
        FlowFormTemplate nextFormTemplate = this.getForms().subList(((FlowData)flowData).getCurrentFormIndex() + 1, this.getForms().size()).stream().filter(formTemplate -> formTemplate.mustShow(flowData.getData())).findFirst().orElse(null);
        if (null != nextFormTemplate) {
            this.process(nextFormTemplate.getPreProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            for (FlowInputFieldTemplate flowInputFieldTemplate : nextFormTemplate.getFieldTemplates(((FlowData)flowData).getData(), formData, FlowInputFieldTemplate.class)) {
                flowInputFieldTemplate.preProcess(flowToken, ((FlowData)flowData).getData(), ((FlowData)flowData).getLocale(), httpResponse);
            }
            ((FlowData)flowData).setCurrentFormIndex(this.getForms().indexOf((Object)nextFormTemplate));
        }
        if (Boolean.TRUE.equals((response = this.toResponse(flowToken, nextFormTemplate, flowData, httpRequest, httpResponse)).getFinished())) {
            this.onFinished(flowToken, flowData, formData, httpRequest, httpResponse);
        }
        return response;
    }

    protected FlowFormTemplate getCurrentFormTemplate(D flowData) throws Exception {
        return this.getForms().get(Math.max(((FlowData)flowData).getCurrentFormIndex(), 0));
    }

    protected void onFinished(String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.process(this.getPostProcessors(flowData), flowToken, flowData, formData, httpRequest, httpResponse);
        this.cleanFlowData(flowToken);
    }

    protected void updateFlowData(String flowToken, D flowData) {
        if (this.getFlowDataRepository().contains(flowToken)) {
            this.getFlowDataRepository().put(flowToken, flowData);
        }
    }

    protected void invalidateFlow(InvalidateFlowException ex) {
        this.cleanFlowData(ex.getFlowToken());
    }

    protected FlowResponse toResponse(String flowToken, FlowFormTemplate formTemplate, D flowData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse response = new FlowResponse();
        if (null != formTemplate) {
            BardForm nextForm = FormUtils.toForm((FormTemplate)formTemplate, ((FlowData)flowData).getData(), ((FlowData)flowData).getData(), (Locale)((FlowData)flowData).getLocale());
            response.setForm(nextForm).setSteps(this.getStepsCounts(flowData)).setCurrent(((FlowData)flowData).getCurrentFormIndex());
        }
        if (null == formTemplate || formTemplate.isFinished()) {
            response.finished();
        } else {
            httpResponse.setHeader("X-Flow-Token", flowToken);
        }
        return response;
    }

    protected FlowResponse handleExceptionInternal(String flowToken, D flowData, Map<String, String> formData, FlowFormTemplate currentFormTemplate, FlowAction flowAction, Exception ex) throws Exception {
        FlowDataValidationException e;
        if (ex instanceof InvalidateFlowException) {
            InvalidateFlowException e2 = (InvalidateFlowException)ex;
            this.invalidateFlow(e2);
        } else if (ex instanceof FlowDataValidationException && (e = (FlowDataValidationException)ex).isSendCurrentForm() && null != currentFormTemplate) {
            e.setForm(FormUtils.toForm((FormTemplate)currentFormTemplate, null == flowData ? null : ((FlowData)flowData).getData(), null == flowData ? null : ((FlowData)flowData).getData(), (Locale)(null == flowData ? null : ((FlowData)flowData).getLocale())));
        }
        return this.handleException(flowToken, flowData, formData, currentFormTemplate, flowAction, ex);
    }

    protected abstract FlowResponse handleException(String var1, D var2, Map<String, String> var3, FlowFormTemplate var4, FlowAction var5, Exception var6) throws Exception;

    protected int getStepsCounts(D flowData) {
        return this.getForms().size();
    }

    protected void cleanFlowData(String flowToken) {
        this.getFlowDataRepository().remove(flowToken);
    }

    protected boolean process(List<FormProcessor> processors, String flowToken, D flowData, Map<String, String> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (CollectionUtils.isEmpty(processors)) {
            return false;
        }
        List executableProcessors = processors.stream().filter(formProcessor -> formProcessor.mustExecute(flowData.getData())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(executableProcessors)) {
            return false;
        }
        for (FormProcessor processor : executableProcessors) {
            processor.process(flowToken, ((FlowData)flowData).getData(), formData, ((FlowData)flowData).getLocale(), httpRequest, httpResponse);
        }
        return true;
    }

    protected void onLocaleChange(String flowToken, D flowData, Map<String, String> formData, FlowAction flowAction, Locale startLocale, Locale newLocale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
    }

    public List<FormProcessor> getPreProcessors(D flowData) {
        return this.preProcessors;
    }

    public List<FormProcessor> getPostProcessors(D flowData) {
        return this.postProcessors;
    }

    public Map<String, List<FormProcessor>> getActionProcessors(D flowData) {
        return this.actionProcessors;
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public FlowDataRepository<D> getFlowDataRepository() {
        return this.flowDataRepository;
    }

    @Generated
    public List<FlowFormTemplate> getForms() {
        return this.forms;
    }

    @Generated
    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    @Generated
    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    @Generated
    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }

    @Generated
    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    @Generated
    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    @Generated
    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }

    public static enum FlowAction {
        START,
        SUBMIT_FORM,
        GET_CURRENT,
        PROCESS_ACTION;

    }
}

