/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.otp.time;

import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bardframework.flow.form.field.input.otp.OtpFieldTemplate;
import org.bardframework.flow.form.field.input.otp.time.OtpServiceAbstract;
import org.bardframework.form.field.input.OtpField;

public class TotpFieldTemplate
extends OtpFieldTemplate<OtpField, Void> {
    public static final String TOTP_SECRET_KEY = "X_TOTP_SECRET";
    protected final OtpServiceAbstract otpService;
    protected String secretAttributeName = "X_TOTP_SECRET";

    public TotpFieldTemplate(String name, int maxTryToResolveCount, OtpServiceAbstract otpService) {
        super(name, otpService, maxTryToResolveCount);
        this.otpService = otpService;
    }

    @Override
    protected String getResendAction() {
        return null;
    }

    @Override
    protected void send(String flowToken, Map<String, String> flowData, Void otp, Locale locale, HttpServletResponse httpResponse) throws Exception {
    }

    @Override
    protected boolean isValidOtp(String flowToken, String otp, Map<String, String> flowData) throws Exception {
        String totpSecretBase64 = flowData.get(this.getSecretAttributeName());
        byte[] totpSecret = Base64.getDecoder().decode(totpSecretBase64);
        return this.otpService.verify(otp, totpSecret);
    }

    @Override
    protected String getOtpMaxTryToResolveCountErrorMessage() {
        return "totp.error.max.resolve.exceeded";
    }

    @Override
    protected String getMaxSendCountErrorMessage() {
        return "totp.error.max.send.exceeded";
    }

    @Generated
    public OtpServiceAbstract getOtpService() {
        return this.otpService;
    }

    @Generated
    public String getSecretAttributeName() {
        return this.secretAttributeName;
    }

    @Generated
    public void setSecretAttributeName(String secretAttributeName) {
        this.secretAttributeName = secretAttributeName;
    }
}

