/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.processor.dataprovider;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.web.utils.ResourceUtils;
import org.bardframework.commons.web.utils.WebUtils;
import org.bardframework.flow.exception.FlowExecutionException;
import org.bardframework.flow.processor.FormProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProviderCsvFileProcessor
extends FormProcessorAbstract {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataProviderCsvFileProcessor.class);
    protected final String csvFileLocation;
    protected final Map<Integer, String> mapper;
    protected final String identifierFieldName;
    protected final String identifierNotFoundErrorMessageCode;
    protected String separator = ",";

    public DataProviderCsvFileProcessor(String csvFileLocation, String identifierFieldName, Map<Integer, String> mapper, String identifierNotFoundErrorMessageCode) {
        this.csvFileLocation = csvFileLocation;
        this.identifierFieldName = identifierFieldName;
        this.identifierNotFoundErrorMessageCode = identifierNotFoundErrorMessageCode;
        this.mapper = mapper;
    }

    @Override
    public void process(String flowToken, Map<String, String> flowData, Map<String, String> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String identifier = flowData.get(this.getIdentifierFieldName());
        if (StringUtils.isBlank((CharSequence)identifier)) {
            log.warn("identifier not exist for [{}], in csv file", flowData);
            throw new FlowExecutionException(List.of("execution_error"));
        }
        try (InputStream inputStream = ResourceUtils.getResource((String)this.getCsvFileLocation()).getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            do {
                String[] parts;
                if (null == (line = reader.readLine()) || !(parts = new String(line.getBytes(), StandardCharsets.UTF_8).split(this.getSeparator()))[0].trim().equalsIgnoreCase(identifier)) continue;
                for (Integer index : this.mapper.keySet()) {
                    if (index >= parts.length) {
                        log.warn("can't find attribute[{}] value for[{}]", (Object)this.mapper.get(index), (Object)identifier);
                        continue;
                    }
                    flowData.put(this.mapper.get(index), WebUtils.escapeString((String)parts[index]));
                }
                return;
            } while (line != null);
        }
        log.warn("can't find record for[{}] in csv file [{}]", (Object)identifier, (Object)this.getCsvFileLocation());
        throw new FlowExecutionException(List.of(this.identifierNotFoundErrorMessageCode));
    }

    @Generated
    public String getCsvFileLocation() {
        return this.csvFileLocation;
    }

    @Generated
    public Map<Integer, String> getMapper() {
        return this.mapper;
    }

    @Generated
    public String getIdentifierFieldName() {
        return this.identifierFieldName;
    }

    @Generated
    public String getIdentifierNotFoundErrorMessageCode() {
        return this.identifierNotFoundErrorMessageCode;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

