/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.otp;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.exception.MaxOtpSendExceededException;
import org.bardframework.flow.form.field.input.FlowInputFieldTemplate;
import org.bardframework.flow.form.field.input.otp.OtpGenerator;
import org.bardframework.flow.processor.FormProcessorAbstract;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.field.input.OtpField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public abstract class OtpFieldTemplate<F extends OtpField, O>
extends FlowInputFieldTemplate<F, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtpFieldTemplate.class);
    private static final String GENERATE_COUNT_KEY = "X_GENERATE_COUNT";
    private static final String RESOLVE_COUNT_KEY = "X_RESOLVE_COUNT";
    private static final String SENT_TIME_KEY = "X_SENT_TIME";
    private static final String RESEND_COUNT_KEY = "X_RESEND_COUNT";
    private final OtpGenerator<O> otpGenerator;
    private final int maxTryToResolveCount;
    private int maxSendCount = 20;
    private Integer resendIntervalSeconds;

    public OtpFieldTemplate(String name, OtpGenerator<O> otpGenerator, int maxTryToResolveCount) {
        super(name, false);
        this.otpGenerator = otpGenerator;
        this.maxTryToResolveCount = maxTryToResolveCount;
    }

    protected abstract String getResendAction();

    protected abstract void send(String var1, Map<String, Object> var2, O var3, Locale var4, HttpServletResponse var5) throws Exception;

    protected abstract boolean isValidOtp(String var1, String var2, Map<String, Object> var3) throws Exception;

    @PostConstruct
    void init() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getResendAction()})) {
            this.setActionProcessors(Map.of(this.getResendAction(), List.of(new FormProcessorAbstract(){

                @Override
                public void process(String flowToken, Map<String, Object> flowData, Map<String, Object> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
                    OtpFieldTemplate.this.resend(flowToken, flowData, locale, httpResponse);
                }
            })));
        }
    }

    public final boolean isValid(String flowToken, F field, String value, Map<String, Object> flowData) throws Exception {
        int resolveTryCount;
        if (StringUtils.isBlank((CharSequence)value)) {
            log.debug("field otp [{}] is required, but it's value is empty", (Object)field.getName());
            return false;
        }
        if ((value = value.replace(" ", "")).length() != this.getOtpGenerator().getLength()) {
            log.debug("field [{}] length is [{}], than not equal to it's value[{}] length.", new Object[]{field.getName(), field.getLength(), value.length()});
            return false;
        }
        if (this.isValidOtp(flowToken, value, flowData)) {
            flowData.remove(GENERATE_COUNT_KEY);
            flowData.remove(RESOLVE_COUNT_KEY);
            flowData.remove(SENT_TIME_KEY);
            flowData.remove(RESEND_COUNT_KEY);
            return true;
        }
        int n = resolveTryCount = flowData.containsKey(RESOLVE_COUNT_KEY) ? (Integer)flowData.get(RESOLVE_COUNT_KEY) : 0;
        if (resolveTryCount >= this.getMaxTryToResolveCount()) {
            throw new InvalidateFlowException(flowToken, "invalid otp", this.getOtpMaxTryToResolveCountErrorMessage());
        }
        flowData.put(RESOLVE_COUNT_KEY, String.valueOf(resolveTryCount + 1));
        return false;
    }

    public void fill(FormTemplate formTemplate, F field, Map<String, Object> values, Map<String, Object> args, Locale locale) throws Exception {
        super.fill(formTemplate, field, values, args, locale);
        field.setLength(this.getOtpGenerator().getLength());
        field.setResendAction(this.getResendAction());
        field.setResendIntervalSeconds(this.getResendIntervalSeconds());
        field.setNumber(this.getOtpGenerator().isNumber());
        field.setRequired(Boolean.valueOf(true));
    }

    protected void sendInternal(String flowToken, Map<String, Object> flowData, Locale locale, HttpServletResponse httpResponse) throws Exception {
        int generateCount;
        int n = generateCount = flowData.containsKey(GENERATE_COUNT_KEY) ? (Integer)flowData.get(GENERATE_COUNT_KEY) : 0;
        if (generateCount > this.getMaxSendCount()) {
            throw new MaxOtpSendExceededException(flowToken, "max otp send (generate) count exceed", this.getMaxSendCountErrorMessage());
        }
        this.send(flowToken, flowData, this.getOtpGenerator().generate(), locale, httpResponse);
        flowData.put(SENT_TIME_KEY, String.valueOf(System.currentTimeMillis()));
        flowData.put(GENERATE_COUNT_KEY, String.valueOf(generateCount + 1));
    }

    public void resend(String flowToken, Map<String, Object> flowData, Locale locale, HttpServletResponse httpResponse) throws Exception {
        int resendCount;
        int n = resendCount = flowData.containsKey(RESEND_COUNT_KEY) ? (Integer)flowData.get(RESEND_COUNT_KEY) : 0;
        if (resendCount > this.getMaxSendCount()) {
            httpResponse.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            log.error("flowToken[{}], max otp resend exceed", (Object)flowToken);
            return;
        }
        long sentTime = flowData.containsKey(SENT_TIME_KEY) ? (Long)flowData.get(SENT_TIME_KEY) : 0L;
        long remainSeconds = (long)this.getResendIntervalSeconds().intValue() - (System.currentTimeMillis() - sentTime) / 1000L;
        if (remainSeconds > 0L) {
            log.error("flowToken[{}], try to resend otp, before resend interval!", (Object)flowToken);
            httpResponse.getWriter().println(remainSeconds);
            httpResponse.setStatus(HttpStatus.TOO_EARLY.value());
            return;
        }
        this.sendInternal(flowToken, flowData, locale, httpResponse);
    }

    protected abstract String getOtpMaxTryToResolveCountErrorMessage();

    protected abstract String getMaxSendCountErrorMessage();

    @Generated
    public OtpGenerator<O> getOtpGenerator() {
        return this.otpGenerator;
    }

    @Generated
    public int getMaxTryToResolveCount() {
        return this.maxTryToResolveCount;
    }

    @Generated
    public int getMaxSendCount() {
        return this.maxSendCount;
    }

    @Generated
    public Integer getResendIntervalSeconds() {
        return this.resendIntervalSeconds;
    }

    @Generated
    public void setMaxSendCount(int maxSendCount) {
        this.maxSendCount = maxSendCount;
    }

    @Generated
    public void setResendIntervalSeconds(Integer resendIntervalSeconds) {
        this.resendIntervalSeconds = resendIntervalSeconds;
    }
}

