/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.otp.time;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bardframework.flow.form.field.input.otp.OtpGenerator;

public abstract class OtpServiceAbstract
implements OtpGenerator<Void> {
    private String algorithm = "SHA1";
    private String hmacAlgorithm = "HmacSHA1";
    private String hmacProvider = "SunJCE";
    private String rngAlgorithm = "SHA1PRNG";
    private String rngProvider = "SUN";
    private int length = 6;
    private int secretSize = 30;

    public abstract String generate(byte[] var1);

    public abstract boolean verify(String var1, byte[] var2) throws GeneralSecurityException;

    protected byte[] hmac(byte[] input, byte[] secret) throws GeneralSecurityException {
        Mac mac = Mac.getInstance(this.getHmacAlgorithm(), this.getHmacProvider());
        mac.init(new SecretKeySpec(secret, this.getHmacAlgorithm()));
        return mac.doFinal(input);
    }

    public byte[] generateSecret() throws GeneralSecurityException {
        byte[] secret = new byte[this.getSecretSize()];
        SecureRandom random = SecureRandom.getInstance(this.getRngAlgorithm(), this.getRngProvider());
        random.nextBytes(secret);
        return secret;
    }

    @Override
    public Void generate() {
        return null;
    }

    @Override
    public Boolean isNumber() {
        return true;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public String getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    @Generated
    public String getHmacProvider() {
        return this.hmacProvider;
    }

    @Generated
    public String getRngAlgorithm() {
        return this.rngAlgorithm;
    }

    @Generated
    public String getRngProvider() {
        return this.rngProvider;
    }

    @Generated
    public int getSecretSize() {
        return this.secretSize;
    }

    @Generated
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setHmacAlgorithm(String hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
    }

    @Generated
    public void setHmacProvider(String hmacProvider) {
        this.hmacProvider = hmacProvider;
    }

    @Generated
    public void setRngAlgorithm(String rngAlgorithm) {
        this.rngAlgorithm = rngAlgorithm;
    }

    @Generated
    public void setRngProvider(String rngProvider) {
        this.rngProvider = rngProvider;
    }

    @Generated
    public void setLength(int length) {
        this.length = length;
    }

    @Generated
    public void setSecretSize(int secretSize) {
        this.secretSize = secretSize;
    }
}

