/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.flow.FlowResponse;
import org.bardframework.flow.exception.FlowDataValidationException;
import org.bardframework.flow.exception.FlowExecutionException;
import org.bardframework.form.exception.FormDataValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;

public interface FlowExceptionControllerAdvice {
    public static final Logger log = LoggerFactory.getLogger(FlowExceptionControllerAdvice.class);

    @ExceptionHandler(value={FlowDataValidationException.class})
    default public ResponseEntity<FlowResponse> handle(FlowDataValidationException ex) {
        log.debug("flow data validation error: [{}]", (Object)ex.getMessage());
        log.trace("flow data validation error.", (Throwable)ex);
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String errorFieldName : ex.getFieldErrors().keySet()) {
            Object errorMessageCode = ex.getFieldErrors().get(errorFieldName);
            if (null != errorMessageCode) {
                errors.put(errorFieldName, this.getMessageSource().getMessage(errorMessageCode.toString(), null, errorMessageCode.toString(), LocaleContextHolder.getLocale()));
                continue;
            }
            errors.put(errorFieldName, "");
        }
        FlowResponse response = new FlowResponse();
        response.setFieldErrors(errors);
        response.setForm(ex.getForm());
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @ExceptionHandler(value={FlowExecutionException.class})
    default public ResponseEntity<FlowResponse> handle(FlowExecutionException ex) {
        log.debug("flow execution error: {}", ex.getErrorsMessageCodes());
        List errors = ex.getErrorsMessageCodes().stream().map(errorMessageCode -> this.getMessageSource().getMessage(errorMessageCode, null, errorMessageCode, LocaleContextHolder.getLocale())).collect(Collectors.toList());
        FlowResponse response = new FlowResponse();
        response.setErrors(errors);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    @ExceptionHandler(value={FormDataValidationException.class})
    default public ResponseEntity<FlowResponse> handle(FormDataValidationException ex) {
        log.debug("form data validation error: {}", (Object)ex.getMessage());
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        for (Map.Entry entry : ex.getInvalidFields().entrySet()) {
            List errors = CollectionUtils.emptyIfNull((Collection)((Collection)entry.getValue())).stream().filter(Objects::nonNull).collect(Collectors.toList());
            fieldErrors.put((String)entry.getKey(), errors.isEmpty() ? null : String.join((CharSequence)"\n", errors));
        }
        FlowResponse response = new FlowResponse();
        response.setFieldErrors(fieldErrors);
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    public MessageSource getMessageSource();
}

