/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.flow.FlowData;
import org.bardframework.flow.FlowHandler;
import org.bardframework.flow.FlowResponse;
import org.bardframework.flow.exception.FlowDataValidationException;
import org.bardframework.flow.exception.InvalidateFlowException;
import org.bardframework.flow.form.FlowFormTemplate;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.flow.form.field.input.FlowInputFieldTemplate;
import org.bardframework.flow.repository.FlowDataRepository;
import org.bardframework.form.BardForm;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.FormUtils;
import org.bardframework.form.exception.FormDataValidationException;
import org.bardframework.form.field.input.InputFieldTemplateAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FlowHandlerAbstract<D extends FlowData>
implements FlowHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected final FlowDataRepository<D> flowDataRepository;
    protected final Supplier<List<FlowFormTemplate>> formsSupplier;
    protected List<FormProcessor> preProcessors = new ArrayList<FormProcessor>();
    protected List<FormProcessor> postProcessors = new ArrayList<FormProcessor>();
    protected Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();

    @Autowired
    public FlowHandlerAbstract(String name, FlowDataRepository<D> flowDataRepository, List<FlowFormTemplate> forms) {
        this(name, flowDataRepository, () -> forms);
    }

    public FlowHandlerAbstract(String name, FlowDataRepository<D> flowDataRepository, Supplier<List<FlowFormTemplate>> formsSupplier) {
        this.name = name;
        this.flowDataRepository = flowDataRepository;
        this.formsSupplier = formsSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse start(Map<String, Object> initValues, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = (FlowData)ReflectionUtils.newInstance((Class)ReflectionUtils.getGenericArgType(this.getClass(), (int)0));
        String flowToken = this.generateFlowToken();
        flowData.setLocale(locale);
        flowData.getData().putAll(initValues);
        flowData.setCurrentFormIndex(-1);
        this.getFlowDataRepository().put(flowToken, flowData);
        FlowFormTemplate currentFormTemplate = null;
        try {
            this.process(this.getPreProcessors(flowData), flowToken, flowData, Map.of(), httpRequest, httpResponse);
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
            FlowResponse flowResponse = this.processNextForm(flowToken, flowData, Map.of(), httpRequest, httpResponse);
            return flowResponse;
        }
        catch (Exception e) {
            FlowResponse flowResponse = this.handleExceptionInternal(flowToken, flowData, initValues, currentFormTemplate, FlowAction.START, httpRequest, httpResponse, e);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowResponse submit(String flowToken, Map<String, Object> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = null;
        FlowFormTemplate currentFormTemplate = null;
        try {
            flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
        }
        catch (Exception ex) {
            return this.handleExceptionInternal(flowToken, flowData, formData, currentFormTemplate, FlowAction.SUBMIT_FORM, httpRequest, httpResponse, ex);
        }
        try {
            if (!Objects.equals(locale, flowData.getLocale())) {
                this.onLocaleChange(flowToken, flowData, formData, FlowAction.SUBMIT_FORM, flowData.getLocale(), locale, httpRequest, httpResponse);
            }
            FormUtils.validate((String)flowToken, (FormTemplate)currentFormTemplate, flowData.getData(), formData, (Locale)flowData.getLocale(), (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            this.fillFlowData(flowData.getData(), formData, currentFormTemplate, httpRequest, httpResponse);
            this.process(currentFormTemplate.getPostProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            FlowResponse ex = this.processNextForm(flowToken, flowData, formData, httpRequest, httpResponse);
            return ex;
        }
        catch (Exception ex) {
            FlowResponse flowResponse = this.handleExceptionInternal(flowToken, flowData, formData, currentFormTemplate, FlowAction.SUBMIT_FORM, httpRequest, httpResponse, ex);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object action(String flowToken, String action, Map<String, Object> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.log.debug("start action[{}] processing, flow token [{}], form data [{}]", new Object[]{action, flowToken, formData});
        FlowData flowData = null;
        FlowFormTemplate currentFormTemplate = null;
        try {
            flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
            if (StringUtils.isBlank((CharSequence)action)) {
                this.log.warn("null action can't process, flow token [{}], form [{}]", (Object)flowToken, (Object)currentFormTemplate.getName());
                httpResponse.setStatus(404);
                Object var9_9 = null;
                return var9_9;
            }
            if (!Objects.equals(locale, flowData.getLocale())) {
                this.onLocaleChange(flowToken, flowData, formData, FlowAction.PROCESS_ACTION, flowData.getLocale(), locale, httpRequest, httpResponse);
            }
            if (!this.processAction(flowToken, action, flowData, formData, currentFormTemplate, httpRequest, httpResponse)) {
                this.log.warn("no processor exist to handle action [{}], flow token [{}], form [{}]", new Object[]{action, flowToken, currentFormTemplate.getName()});
                throw new InvalidateFlowException(flowToken, "invalid action", null);
            }
        }
        catch (Exception ex) {
            FlowResponse flowResponse = this.handleExceptionInternal(flowToken, flowData, formData, currentFormTemplate, FlowAction.PROCESS_ACTION, httpRequest, httpResponse, ex);
            return flowResponse;
        }
        finally {
            this.updateFlowData(flowToken, flowData);
        }
        return null;
    }

    @Override
    public FlowResponse getCurrent(String flowToken, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowData flowData = null;
        FlowFormTemplate currentFormTemplate = null;
        try {
            flowData = (FlowData)this.getFlowDataRepository().get(flowToken);
            if (flowData.getCurrentFormIndex() == 0) {
                flowData.setLocale(locale);
                this.updateFlowData(flowToken, flowData);
            }
            currentFormTemplate = this.getCurrentFormTemplate(flowData);
            if (!Objects.equals(locale, flowData.getLocale())) {
                this.onLocaleChange(flowToken, flowData, Map.of(), FlowAction.GET_CURRENT, flowData.getLocale(), locale, httpRequest, httpResponse);
            }
            return this.toResponse(flowToken, currentFormTemplate, flowData, httpRequest, httpResponse);
        }
        catch (Exception ex) {
            return this.handleExceptionInternal(flowToken, flowData, Map.of(), currentFormTemplate, FlowAction.GET_CURRENT, httpRequest, httpResponse, ex);
        }
    }

    protected boolean processAction(String flowToken, String action, D flowData, Map<String, Object> formData, FlowFormTemplate currentFormTemplate, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        for (FlowInputFieldTemplate fieldTemplate : currentFormTemplate.getFieldTemplates(((FlowData)flowData).getData(), formData, FlowInputFieldTemplate.class, httpRequest, httpResponse)) {
            if (!this.process(fieldTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) continue;
            return true;
        }
        if (this.process(currentFormTemplate.getActionProcessors().get(action), flowToken, flowData, formData, httpRequest, httpResponse)) {
            return true;
        }
        return this.process(this.getActionProcessors(flowData).get(action), flowToken, flowData, formData, httpRequest, httpResponse);
    }

    protected void fillFlowData(Map<String, Object> flowData, Map<String, Object> formData, FlowFormTemplate currentFormTemplate, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        for (InputFieldTemplateAbstract inputFieldTemplate : currentFormTemplate.getFieldTemplates(flowData, formData, InputFieldTemplateAbstract.class, httpRequest, httpResponse)) {
            if (!inputFieldTemplate.isPersistentValue()) continue;
            Object value = formData.get(inputFieldTemplate.getName());
            if (!Boolean.TRUE.equals(currentFormTemplate.getSubmitEmptyInputs()) && null == value) continue;
            flowData.put(inputFieldTemplate.getName(), value);
        }
    }

    protected FlowResponse processNextForm(String flowToken, D flowData, Map<String, Object> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse response;
        FlowFormTemplate nextFormTemplate = this.getForms().subList(((FlowData)flowData).getCurrentFormIndex() + 1, this.getForms().size()).stream().filter(formTemplate -> formTemplate.mustShow(flowData.getData())).findFirst().orElse(null);
        if (null != nextFormTemplate) {
            this.process(nextFormTemplate.getPreProcessors(), flowToken, flowData, formData, httpRequest, httpResponse);
            List<FlowInputFieldTemplate> flowInputFieldTemplates = nextFormTemplate.getFieldTemplates(((FlowData)flowData).getData(), formData, FlowInputFieldTemplate.class, httpRequest, httpResponse).stream().filter(Objects::nonNull).filter(flowInputFieldTemplate -> flowInputFieldTemplate instanceof FlowInputFieldTemplate).toList();
            for (FlowInputFieldTemplate flowInputFieldTemplate2 : flowInputFieldTemplates) {
                flowInputFieldTemplate2.preProcess(flowToken, ((FlowData)flowData).getData(), ((FlowData)flowData).getLocale(), httpResponse);
            }
            ((FlowData)flowData).setCurrentFormIndex(this.getForms().indexOf((Object)nextFormTemplate));
        }
        if (Boolean.TRUE.equals((response = this.toResponse(flowToken, nextFormTemplate, flowData, httpRequest, httpResponse)).getFinished())) {
            this.onFinished(flowToken, flowData, formData, httpRequest, httpResponse);
        }
        return response;
    }

    protected FlowFormTemplate getCurrentFormTemplate(D flowData) throws Exception {
        return this.getForms().get(Math.max(((FlowData)flowData).getCurrentFormIndex(), 0));
    }

    protected void onFinished(String flowToken, D flowData, Map<String, Object> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.process(this.getPostProcessors(flowData), flowToken, flowData, formData, httpRequest, httpResponse);
        this.cleanFlowData(flowToken);
    }

    protected void updateFlowData(String flowToken, D flowData) {
        if (this.getFlowDataRepository().contains(flowToken)) {
            this.getFlowDataRepository().put(flowToken, flowData);
        }
    }

    protected void invalidateFlow(InvalidateFlowException ex) {
        this.cleanFlowData(ex.getFlowToken());
    }

    protected FlowResponse toResponse(String flowToken, FlowFormTemplate formTemplate, D flowData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        FlowResponse response = new FlowResponse();
        if (null != formTemplate) {
            BardForm nextForm = FormUtils.toForm((FormTemplate)formTemplate, ((FlowData)flowData).getData(), ((FlowData)flowData).getData(), (Locale)((FlowData)flowData).getLocale(), (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            response.setForm(nextForm).setSteps(this.getStepsCounts(flowData)).setCurrent(((FlowData)flowData).getCurrentFormIndex());
        }
        if (null == formTemplate || formTemplate.isFinished()) {
            response.finished();
        } else {
            response.setId(flowToken);
        }
        return response;
    }

    protected FlowResponse handleExceptionInternal(String flowToken, D flowData, Map<String, Object> formData, FlowFormTemplate currentFormTemplate, FlowAction flowAction, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Exception ex) throws Exception {
        FlowDataValidationException e;
        if (ex instanceof InvalidateFlowException) {
            InvalidateFlowException e2 = (InvalidateFlowException)ex;
            this.invalidateFlow(e2);
        } else if (ex instanceof FlowDataValidationException && (e = (FlowDataValidationException)ex).isSendCurrentForm() && null != currentFormTemplate) {
            e.setForm(FormUtils.toForm((FormTemplate)currentFormTemplate, null == flowData ? null : ((FlowData)flowData).getData(), null == flowData ? null : ((FlowData)flowData).getData(), (Locale)(null == flowData ? null : ((FlowData)flowData).getLocale()), (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse));
        }
        if (!(ex instanceof FlowDataValidationException) && !(ex instanceof FormDataValidationException)) {
            this.log.error("error in flow [{}].", (Object)flowToken, (Object)ex);
        }
        return this.handleException(flowToken, flowData, formData, currentFormTemplate, flowAction, httpRequest, httpResponse, ex);
    }

    protected abstract FlowResponse handleException(String var1, D var2, Map<String, Object> var3, FlowFormTemplate var4, FlowAction var5, HttpServletRequest var6, HttpServletResponse var7, Exception var8) throws Exception;

    protected int getStepsCounts(D flowData) {
        return this.getForms().size();
    }

    protected void cleanFlowData(String flowToken) {
        this.getFlowDataRepository().remove(flowToken);
    }

    protected boolean process(List<FormProcessor> processors, String flowToken, D flowData, Map<String, Object> formData, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (CollectionUtils.isEmpty(processors)) {
            return false;
        }
        List executableProcessors = processors.stream().filter(formProcessor -> formProcessor.mustExecute(flowData.getData())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(executableProcessors)) {
            return false;
        }
        for (FormProcessor processor : executableProcessors) {
            processor.process(flowToken, ((FlowData)flowData).getData(), formData, ((FlowData)flowData).getLocale(), httpRequest, httpResponse);
        }
        return true;
    }

    protected void onLocaleChange(String flowToken, D flowData, Map<String, Object> formData, FlowAction flowAction, Locale startLocale, Locale newLocale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
    }

    public List<FormProcessor> getPreProcessors(D flowData) {
        return this.preProcessors;
    }

    public List<FormProcessor> getPostProcessors(D flowData) {
        return this.postProcessors;
    }

    public Map<String, List<FormProcessor>> getActionProcessors(D flowData) {
        return this.actionProcessors;
    }

    public List<FlowFormTemplate> getForms() {
        return this.formsSupplier.get();
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public FlowDataRepository<D> getFlowDataRepository() {
        return this.flowDataRepository;
    }

    @Generated
    public Supplier<List<FlowFormTemplate>> getFormsSupplier() {
        return this.formsSupplier;
    }

    @Generated
    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    @Generated
    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    @Generated
    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }

    @Generated
    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    @Generated
    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    @Generated
    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }

    public static enum FlowAction {
        START,
        SUBMIT_FORM,
        GET_CURRENT,
        PROCESS_ACTION;

    }
}

