/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.bardframework.flow.form.FormProcessor;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.field.FieldTemplate;
import org.springframework.context.MessageSource;

public class FlowFormTemplate
extends FormTemplate {
    private List<FormProcessor> preProcessors = new ArrayList<FormProcessor>();
    private List<FormProcessor> postProcessors = new ArrayList<FormProcessor>();
    private Map<String, List<FormProcessor>> actionProcessors = new HashMap<String, List<FormProcessor>>();
    private boolean finished;

    public FlowFormTemplate(String name, List<FieldTemplate<?>> fieldTemplates, MessageSource messageSource) {
        super(name, fieldTemplates, messageSource);
    }

    @PostConstruct
    protected void configurationValidate() {
        if (CollectionUtils.isNotEmpty(this.getPostProcessors()) && this.isFinished()) {
            throw new IllegalStateException("when finished is true, can't set postProcessors");
        }
        this.getPreProcessors().forEach(processor -> processor.configurationValidate(this));
        this.getPostProcessors().forEach(processor -> processor.configurationValidate(this));
    }

    @Generated
    public List<FormProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    @Generated
    public List<FormProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    @Generated
    public Map<String, List<FormProcessor>> getActionProcessors() {
        return this.actionProcessors;
    }

    @Generated
    public boolean isFinished() {
        return this.finished;
    }

    @Generated
    public void setPreProcessors(List<FormProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    @Generated
    public void setPostProcessors(List<FormProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    @Generated
    public void setActionProcessors(Map<String, List<FormProcessor>> actionProcessors) {
        this.actionProcessors = actionProcessors;
    }

    @Generated
    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

