/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.captcha;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import lombok.Generated;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AudioCaptchaGenerator {
    private final Map<String, Map<String, List<byte[]>>> audios = new HashMap<String, Map<String, List<byte[]>>>();
    private final boolean enabled;

    public AudioCaptchaGenerator(@Value(value="${captcha.audio.enabled:false}") boolean enabled) throws Exception {
        this.enabled = enabled;
        if (!enabled) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        File baseDir = new File(classLoader.getResource("audio_captcha").toURI());
        Files.find(baseDir.toPath(), 10, (path, basicFileAttributes) -> path.toFile().isFile(), new FileVisitOption[0]).forEach(path -> {
            Path relativePath = baseDir.toPath().relativize((Path)path);
            relativePath = relativePath.getParent().getParent().relativize(relativePath);
            String locale = relativePath.getParent().toString();
            this.audios.putIfAbsent(locale, new HashMap());
            String name = path.getFileName().toFile().getName().split("\\.")[0];
            this.audios.get(locale).putIfAbsent(name, new ArrayList());
            try {
                this.audios.get(locale).get(name).add(Files.readAllBytes(path));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public byte[] generate(String text, String lang) throws UnsupportedAudioFileException, IOException {
        ArrayList<byte[]> captcha = new ArrayList<byte[]>();
        for (char c : text.toLowerCase().toCharArray()) {
            List<byte[]> variants = this.audios.get(lang).get(String.valueOf(c));
            captcha.add(variants.get(RandomUtils.secure().randomInt(0, variants.size())));
        }
        return this.mergeWaves(captcha);
    }

    public void generate(String text, HttpServletResponse httpResponse, String lang) {
        byte[] audio = this.generate(text, lang);
        httpResponse.setContentType("audio/wav");
        httpResponse.setContentLength(audio.length);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            outputStream.write(audio);
            outputStream.flush();
        }
    }

    protected byte[] mergeWaves(List<byte[]> waves) throws UnsupportedAudioFileException, IOException {
        ArrayList<AudioInputStream> audioStreams = new ArrayList<AudioInputStream>();
        AudioFormat audioFormat = null;
        for (byte[] wave : waves) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(wave);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            audioStreams.add(audioInputStream);
            if (audioFormat == null) {
                audioFormat = audioInputStream.getFormat();
                continue;
            }
            if (audioInputStream.getFormat().matches(audioFormat)) continue;
            throw new IllegalStateException("Audio format does not match");
        }
        AudioInputStream appendedStream = (AudioInputStream)audioStreams.get(0);
        for (int i = 1; i < audioStreams.size(); ++i) {
            appendedStream = new AudioInputStream(new SequenceInputStream(appendedStream, (InputStream)audioStreams.get(i)), audioFormat, appendedStream.getFrameLength() + ((AudioInputStream)audioStreams.get(i)).getFrameLength());
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            AudioSystem.write(appendedStream, AudioFileFormat.Type.WAVE, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    @Generated
    public Map<String, Map<String, List<byte[]>>> getAudios() {
        return this.audios;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }
}

