/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.form.field.input.captcha;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.bardframework.commons.captcha.GeneratedCaptcha;
import org.bardframework.flow.form.field.input.captcha.AudioCaptchaGenerator;
import org.bardframework.flow.form.field.input.captcha.CaptchaGeneratorDefault;
import org.bardframework.flow.form.field.input.otp.OtpFieldTemplate;
import org.bardframework.flow.processor.FormProcessorAbstract;
import org.bardframework.form.FormTemplate;
import org.bardframework.form.field.input.CaptchaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaFieldTemplate
extends OtpFieldTemplate<CaptchaField, GeneratedCaptcha> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CaptchaFieldTemplate.class);
    private static final String ANSWER_KEY = "X_ANSWER_CAPTCHA";
    private final CaptchaGeneratorDefault captchaGenerator;
    private final AudioCaptchaGenerator audioCaptchaGenerator;

    public CaptchaFieldTemplate(String name, CaptchaGeneratorDefault otpGenerator, AudioCaptchaGenerator audioCaptchaGenerator) {
        super(name, otpGenerator, 1);
        this.captchaGenerator = otpGenerator;
        this.audioCaptchaGenerator = audioCaptchaGenerator;
    }

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        if (this.audioCaptchaGenerator.isEnabled()) {
            this.getActionProcessors().put(this.getAudioAction(), List.of(new FormProcessorAbstract(){

                @Override
                public void process(String flowToken, Map<String, Object> flowData, Map<String, Object> formData, Locale locale, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
                    Object otp = flowData.get(CaptchaFieldTemplate.ANSWER_KEY);
                    CaptchaFieldTemplate.this.audioCaptchaGenerator.generate(otp.toString(), httpResponse, CaptchaFieldTemplate.this.captchaGenerator.getLang());
                }
            }));
        }
    }

    @Override
    public void fill(FormTemplate formTemplate, CaptchaField field, Map<String, Object> values, Map<String, Object> args, Locale locale) throws Exception {
        super.fill(formTemplate, field, values, args, locale);
        if (this.audioCaptchaGenerator.isEnabled()) {
            field.setAudioAction(this.getAudioAction());
        }
    }

    @Override
    protected void send(String flowToken, Map<String, Object> flowData, GeneratedCaptcha generatedCaptcha, Locale locale, HttpServletResponse httpResponse) throws Exception {
        flowData.put(ANSWER_KEY, generatedCaptcha.getValue());
        IOUtils.write((String)("data:image/png;base64," + Base64.getEncoder().encodeToString(generatedCaptcha.getImage())), (OutputStream)httpResponse.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        httpResponse.setHeader("Content-Type", "image/png");
        httpResponse.setStatus(200);
    }

    @Override
    protected boolean isValidOtp(String flowToken, String captcha, Map<String, Object> flowData) throws Exception {
        Object expectedAnswer = flowData.remove(ANSWER_KEY);
        if (null == expectedAnswer) {
            log.debug("captcha answer in flow data is blank, flow token: [{}]", (Object)flowToken);
            return false;
        }
        return expectedAnswer.toString().equalsIgnoreCase(captcha);
    }

    @Override
    protected String getResendAction() {
        return "captcha-resend";
    }

    protected String getAudioAction() {
        return "audio";
    }

    public int getValidationOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    protected String getOtpMaxTryToResolveCountErrorMessage() {
        return "captcha.error.max.resolve.exceeded";
    }

    @Override
    protected String getMaxSendCountErrorMessage() {
        return "captcha.error.max.send.exceeded";
    }

    @Generated
    public CaptchaGeneratorDefault getCaptchaGenerator() {
        return this.captchaGenerator;
    }

    @Generated
    public AudioCaptchaGenerator getAudioCaptchaGenerator() {
        return this.audioCaptchaGenerator;
    }
}

