/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.HijrahDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Supplier;
import org.bardframework.commons.utils.DateTimeUtils;
import org.bardframework.commons.web.Calendar;
import org.bardframework.table.header.DateHeader;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.time.LocalDateTimeJalali;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class EpochMillsHeaderTemplate<M>
extends HeaderTemplate<M, DateHeader, Long> {
    private static final Logger log = LoggerFactory.getLogger(EpochMillsHeaderTemplate.class);
    private final DateTimeFormatter formatter;
    private DateTimeFormatter exportFormatter;
    private Supplier<ZoneId> timeZoneProvider = ZoneId::systemDefault;
    private Supplier<Calendar> calendarProvider = () -> Calendar.GREGORIAN;

    public EpochMillsHeaderTemplate(String formatterPattern) {
        this.formatter = DateTimeFormatter.ofPattern(formatterPattern);
        this.exportFormatter = DateTimeFormatter.ofPattern(formatterPattern);
    }

    @Override
    public DateHeader getEmptyHeader() {
        return new DateHeader();
    }

    @Override
    public Object format(Long value, MessageSource messageSource, Locale locale) {
        LocalDateTime dateTime = DateTimeUtils.fromEpochMills((long)value, (ZoneId)this.timeZoneProvider.get());
        return this.getFormatter().withLocale(locale).format(dateTime);
    }

    @Override
    public Object formatForExport(Long value, MessageSource messageSource, Locale locale) {
        Comparable<ChronoLocalDateTime<?>> accessor;
        LocalDateTime dateTime = DateTimeUtils.fromEpochMills((long)value, (ZoneId)this.timeZoneProvider.get());
        Calendar calendar = this.calendarProvider.get();
        if (calendar == Calendar.GREGORIAN) {
            accessor = dateTime;
        } else if (calendar == Calendar.JALALI) {
            accessor = LocalDateTimeJalali.of((LocalDateTime)dateTime);
        } else if (calendar == Calendar.ISLAMIC) {
            accessor = HijrahDate.from(dateTime);
        } else {
            throw new IllegalStateException("unhandled calendar: " + String.valueOf(calendar));
        }
        return this.getFormatter().withLocale(locale).format((TemporalAccessor)((Object)accessor));
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public DateTimeFormatter getExportFormatter() {
        return this.exportFormatter;
    }

    public Supplier<ZoneId> getTimeZoneProvider() {
        return this.timeZoneProvider;
    }

    public Supplier<Calendar> getCalendarProvider() {
        return this.calendarProvider;
    }

    public void setExportFormatter(DateTimeFormatter exportFormatter) {
        this.exportFormatter = exportFormatter;
    }

    public void setTimeZoneProvider(Supplier<ZoneId> timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    public void setCalendarProvider(Supplier<Calendar> calendarProvider) {
        this.calendarProvider = calendarProvider;
    }

    @Override
    public String toString() {
        return "EpochMillsHeaderTemplate(formatter=" + String.valueOf(this.getFormatter()) + ", exportFormatter=" + String.valueOf(this.getExportFormatter()) + ", timeZoneProvider=" + String.valueOf(this.getTimeZoneProvider()) + ", calendarProvider=" + String.valueOf(this.getCalendarProvider()) + ")";
    }
}

