/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.util.Locale;
import java.util.Map;
import org.bardframework.commons.utils.ReflectionUtils;
import org.bardframework.table.TableTemplate;
import org.bardframework.table.TableUtils;
import org.bardframework.table.header.TableHeader;
import org.bardframework.table.header.type.HeaderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public abstract class HeaderTemplate<M, H extends TableHeader, T>
extends TableHeader {
    private static final Logger log = LoggerFactory.getLogger(HeaderTemplate.class);
    private String excelFormat;

    public H toHeader(TableTemplate tableTemplate, Map<String, String> args, Locale locale) {
        H header = this.getEmptyHeader();
        header.setName(this.getName());
        this.fill(tableTemplate, header, args, locale);
        return header;
    }

    protected void fill(TableTemplate tableTemplate, H header, Map<String, String> args, Locale locale) {
        header.setTitle(TableUtils.getHeaderStringValue(tableTemplate, this, "title", locale, args, this.getName()));
        header.setDescription(TableUtils.getHeaderStringValue(tableTemplate, this, "description", locale, args, this.getName()));
        header.setHidden(TableUtils.getHeaderBooleanValue(tableTemplate, this, "hidden", locale, args, this.getHidden()));
        header.setSortable(TableUtils.getHeaderBooleanValue(tableTemplate, this, "sortable", locale, args, this.getSortable()));
        header.setMovable(TableUtils.getHeaderBooleanValue(tableTemplate, this, "movable", locale, args, this.getMovable()));
        header.setSticky(TableUtils.getHeaderBooleanValue(tableTemplate, this, "sticky", locale, args, this.getSticky()));
    }

    public abstract H getEmptyHeader();

    public HeaderType getType() {
        return null;
    }

    public Object getValue(M model, MessageSource messageSource, Locale locale, boolean export) {
        T value = this.getValue(model);
        if (null == value) {
            return null;
        }
        if (export) {
            return this.formatForExport(value, messageSource, locale);
        }
        return this.format(value, messageSource, locale);
    }

    protected T getValue(M model) {
        try {
            return (T)ReflectionUtils.getPropertyValue(model, (String)this.getName());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("can't read property [%s] of [%s] instance and convert it.", this.getName(), model.getClass()), e);
        }
    }

    protected Object format(T value, MessageSource messageSource, Locale locale) {
        return value;
    }

    protected Object formatForExport(T value, MessageSource messageSource, Locale locale) {
        return this.format(value, messageSource, locale);
    }

    public String getExcelFormat() {
        return this.excelFormat;
    }

    public void setExcelFormat(String excelFormat) {
        this.excelFormat = excelFormat;
    }

    public String toString() {
        return "HeaderTemplate(excelFormat=" + this.getExcelFormat() + ")";
    }
}

