/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.table.header.TimeHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class LocalTimeHeaderTemplate<M>
extends HeaderTemplate<M, TimeHeader, LocalTime> {
    private static final Logger log = LoggerFactory.getLogger(LocalTimeHeaderTemplate.class);
    private final DateTimeFormatter formatter;

    public LocalTimeHeaderTemplate(String formatterPattern) {
        this.formatter = DateTimeFormatter.ofPattern(formatterPattern);
    }

    @Override
    public TimeHeader getEmptyHeader() {
        return new TimeHeader();
    }

    @Override
    public Object format(LocalTime value, MessageSource messageSource, Locale locale) {
        return this.getFormatter().withLocale(locale).format(value);
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public String toString() {
        return "LocalTimeHeaderTemplate(formatter=" + String.valueOf(this.getFormatter()) + ")";
    }
}

