/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bardframework.crud.api.base.BaseModel;
import org.bardframework.crud.api.base.BaseRepository;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.table.header.StringHeader;
import org.springframework.context.MessageSource;

public abstract class BaseModelHeaderTemplate<M extends BaseModel<I>, R extends BaseRepository<M, ?, I, U>, I, U>
extends HeaderTemplate<M, StringHeader, I> {
    private final Cache<I, M> cache;
    private final R repository;

    protected BaseModelHeaderTemplate(R repository, long cacheExpirationMs) {
        this.cache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(cacheExpirationMs, TimeUnit.MILLISECONDS).build();
        this.repository = repository;
    }

    @Override
    public Object format(I value, MessageSource messageSource, Locale locale) {
        U user = this.getUser();
        BaseModel model = (BaseModel)this.cache.getIfPresent(value);
        if (null == model) {
            model = this.repository.get(value, user);
            if (null == model) {
                return null;
            }
            this.cache.put(value, (Object)model);
        }
        return this.getTitle(model);
    }

    @Override
    public StringHeader getEmptyHeader() {
        return new StringHeader();
    }

    protected abstract U getUser();

    protected abstract String getTitle(M var1);
}

