/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.table.header;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import org.bardframework.table.header.HeaderTemplate;
import org.bardframework.table.header.NumberHeader;
import org.springframework.context.MessageSource;

public class DoubleHeaderTemplate<M>
extends HeaderTemplate<M, NumberHeader, Double> {
    private final int decimalPlaces;

    public DoubleHeaderTemplate(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    public NumberHeader getEmptyHeader() {
        return new NumberHeader();
    }

    protected Double format(Double value, MessageSource messageSource, Locale locale) {
        return BigDecimal.valueOf(value).setScale(this.decimalPlaces, RoundingMode.DOWN).doubleValue();
    }
}

